/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.container.impl;

import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.impl.BuilderWorldHandler;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonTab;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.element.IElement;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.ResourceHelper;
import exopandora.worldhandler.util.UtilRender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiWorldHandler
extends Container {
    private final Content content;
    private final int tabSize;
    private final int bgTextureWidth = 248;
    private final int bgTextureHeight = 166;
    private final int tabDistance = 2;
    private final int tabDistanceTotal;
    private final double tabWidth;
    private final double tabHalf;
    private final double tabEpsilon;
    private final String splash = this.getSplash();
    private final List<GuiButton> finalButtons = new ArrayList<GuiButton>();
    private GuiTextFieldTooltip syntaxField;
    private GuiTextFieldTooltip nameField;
    private static final BuilderWorldHandler BUILDER_WORLD_HANDLER = new BuilderWorldHandler();

    public GuiWorldHandler(Content content) throws Exception {
        this.content = content;
        this.tabSize = this.content.getCategory().getSize();
        this.tabDistanceTotal = Math.max(this.tabSize - 1, 1) * this.tabDistance;
        this.tabWidth = (this.bgTextureWidth - this.tabDistanceTotal) / Math.max(this.tabSize, 2);
        this.tabHalf = this.tabWidth / 2.0;
        this.tabEpsilon = (double)this.bgTextureWidth - ((double)this.tabDistanceTotal + this.tabHalf * (double)Math.max(this.tabSize, 2) * 2.0);
        this.content.init(this);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ActionHelper.tryRun(() -> {
            this.finalButtons.clear();
            this.elements.clear();
            this.field_146292_n.clear();
            this.field_195124_j.clear();
            this.content.onPlayerNameChanged(this.getPlayer());
            this.content.initGui(this, this.getContentX(), this.getContentY());
            for (IElement element : this.elements) {
                element.initGui(this);
            }
            int x = this.field_146294_l / 2 - 10;
            int delta = 21;
            if (Config.getSettings().shortcuts()) {
                this.finalButtons.add(new GuiButtonIcon(x - 147, 0, 20, 20, EnumIcon.TIME_DAWN, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.dawn", (Object[])new Object[]{Config.getSettings().getDawn()})}), ActionHelper::timeDawn));
                this.finalButtons.add(new GuiButtonIcon(x - 126, 0, 20, 20, EnumIcon.TIME_NOON, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.noon", (Object[])new Object[]{Config.getSettings().getNoon()})}), ActionHelper::timeNoon));
                this.finalButtons.add(new GuiButtonIcon(x - 105, 0, 20, 20, EnumIcon.TIME_SUNSET, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.sunset", (Object[])new Object[]{Config.getSettings().getSunset()})}), ActionHelper::timeSunset));
                this.finalButtons.add(new GuiButtonIcon(x - 84, 0, 20, 20, EnumIcon.TIME_MIDNIGHT, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.midnight", (Object[])new Object[]{Config.getSettings().getMidnight()})}), ActionHelper::timeMidnight));
                this.finalButtons.add(new GuiButtonIcon(x - 63, 0, 20, 20, EnumIcon.WEATHER_SUN, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.clear", (Object[])new Object[0])}), ActionHelper::weatherClear));
                this.finalButtons.add(new GuiButtonIcon(x - 42, 0, 20, 20, EnumIcon.WEATHER_RAIN, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.rainy", (Object[])new Object[0])}), ActionHelper::weatherRain));
                this.finalButtons.add(new GuiButtonIcon(x - 21, 0, 20, 20, EnumIcon.WEATHER_STORM, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.thunder", (Object[])new Object[0])}), ActionHelper::weatherThunder));
                this.finalButtons.add(new GuiButtonIcon(x - 0, 0, 20, 20, EnumIcon.DIFFICULTY_PEACEFUL, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.peaceful", (Object[])new Object[0])}), ActionHelper::difficultyPeaceful));
                this.finalButtons.add(new GuiButtonIcon(x + 21, 0, 20, 20, EnumIcon.DIFFICULTY_EASY, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.easy", (Object[])new Object[0])}), ActionHelper::difficultyEasy));
                this.finalButtons.add(new GuiButtonIcon(x + 42, 0, 20, 20, EnumIcon.DIFFICULTY_NORMAL, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.normal", (Object[])new Object[0])}), ActionHelper::difficultyNormal));
                this.finalButtons.add(new GuiButtonIcon(x + 63, 0, 20, 20, EnumIcon.DIFFICULTY_HARD, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.hard", (Object[])new Object[0])}), ActionHelper::difficultyHard));
                this.finalButtons.add(new GuiButtonIcon(x + 84, 0, 20, 20, EnumIcon.GAMEMODE_SURVIVAL, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.survival", (Object[])new Object[0])}), ActionHelper::gamemodeSurvival));
                this.finalButtons.add(new GuiButtonIcon(x + 105, 0, 20, 20, EnumIcon.GAMEMODE_CREATIVE, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.creative", (Object[])new Object[0])}), ActionHelper::gamemodeCreative));
                this.finalButtons.add(new GuiButtonIcon(x + 126, 0, 20, 20, EnumIcon.GAMEMODE_ADVENTURE, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.adventure", (Object[])new Object[0])}), ActionHelper::gamemodeAdventure));
                this.finalButtons.add(new GuiButtonIcon(x + 147, 0, 20, 20, EnumIcon.GAMEMODE_SPECTATOR, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.spectator", (Object[])new Object[0])}), ActionHelper::gamemodeSpectator));
            }
            if (Config.getSettings().commandSyntax()) {
                this.syntaxField = new GuiTextFieldTooltip(x - 147 + 1, this.field_146295_m - 22, 312, 20);
                this.updateSyntax();
            }
            this.nameField = new GuiTextFieldTooltip(0, 0, 0, 11);
            this.nameField.func_146203_f(16);
            this.nameField.func_146180_a(this.getPlayer());
            this.nameField.func_195609_a((id, text) -> {
                WorldHandler.USERNAME = text;
                this.updateNameField();
            });
            this.updateNameField();
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            this.forEachTab((index, xOffset) -> {
                Content tab = this.content.getCategory().getContent((int)index);
                if (!this.content.getActiveContent().equals(tab)) {
                    this.finalButtons.add(new GuiButtonTab((int)((double)backgroundX + xOffset), backgroundY - 20, (int)this.tabWidth + (int)Math.ceil(this.tabEpsilon / (double)this.tabSize), 21, (Integer)index){
                        final /* synthetic */ Integer val$index;
                        {
                            this.val$index = n;
                            super(x, y, widthIn, heightIn);
                        }

                        public void func_194829_a(double mouseX, double mouseY) {
                            ActionHelper.changeTab(GuiWorldHandler.this.content, this.val$index);
                        }
                    });
                }
            });
            this.initButtons();
        });
    }

    @Override
    public void initButtons() {
        this.field_146292_n.clear();
        this.field_195124_j.clear();
        this.content.initButtons(this, this.getContentX(), this.getContentY());
        if (this.finalButtons != null && !this.finalButtons.isEmpty()) {
            this.finalButtons.forEach(this::add);
        }
        if (Config.getSettings().commandSyntax()) {
            this.add(this.syntaxField);
        }
        this.add(this.nameField);
        for (IElement element : this.elements) {
            element.initButtons(this);
        }
    }

    private int getContentX() {
        return (this.field_146294_l - this.bgTextureWidth) / 2 + 8 + this.getXOffset();
    }

    private int getContentY() {
        return this.field_146295_m / 2 - 50 + this.getYOffset();
    }

    private int getXOffset() {
        return 0;
    }

    private int getYOffset() {
        return Config.getSettings().shortcuts() ? 11 : 8;
    }

    public void func_73876_c() {
        ActionHelper.tryRun(this::update);
    }

    private void update() {
        this.content.tick(this);
        for (IElement element : this.elements) {
            element.tick();
        }
        this.updateSyntax();
    }

    private int getBackgroundX() {
        return (this.field_146294_l - this.bgTextureWidth) / 2 + this.getXOffset();
    }

    private int getBackgroundY() {
        return (this.field_146295_m - this.bgTextureHeight) / 2 + this.getYOffset();
    }

    private int getWatchOffset() {
        return Config.getSettings().watch() ? 9 : 0;
    }

    private void forEachTab(BiConsumer<Integer, Double> consumer) {
        double xOffset = 0.0;
        for (int index = 0; index < this.tabSize; ++index) {
            consumer.accept(index, xOffset);
            xOffset += this.tabWidth + (double)this.tabDistance + this.tabEpsilon / (double)this.tabSize;
        }
    }

    private void updateSyntax() {
        if (Config.getSettings().commandSyntax() && this.syntaxField != null) {
            if (!this.syntaxField.func_146206_l()) {
                this.syntaxField.func_200675_a((Predicate)Predicates.alwaysTrue());
                if (this.content.getCommandBuilder() != null) {
                    this.syntaxField.func_146180_a(this.content.getCommandBuilder().toCommand());
                } else {
                    this.syntaxField.func_146180_a(BUILDER_WORLD_HANDLER.toCommand());
                }
                this.syntaxField.func_200675_a(string -> string.equals(this.syntaxField.func_146179_b()));
                this.syntaxField.func_146196_d();
            }
            this.syntaxField.func_146178_a();
        }
    }

    private void updateNameField() {
        int backgroundX = this.getBackgroundX();
        int backgroundY = this.getBackgroundY();
        if (WorldHandler.USERNAME.isEmpty()) {
            int width = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0])) + 2;
            this.nameField.setWidth(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - (this.field_146289_q.func_78256_a(this.content.getTitle()) + 2), backgroundY + 6);
        } else {
            int width = this.field_146289_q.func_78256_a(WorldHandler.USERNAME) + 2;
            this.nameField.setWidth(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - width, backgroundY + 6);
        }
        this.content.onPlayerNameChanged(WorldHandler.USERNAME);
    }

    private void defaultColor() {
        this.defaultColor(1.0f);
    }

    private void defaultColor(float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)Config.getSkin().getBackgroundRedF(), (float)Config.getSkin().getBackgroundGreenF(), (float)Config.getSkin().getBackgroundBlueF(), (float)(alpha * Config.getSkin().getBackgroundAlphaF()));
    }

    private void darkColor() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)(Config.getSkin().getBackgroundRedF() - 0.3f), (float)(Config.getSkin().getBackgroundGreenF() - 0.3f), (float)(Config.getSkin().getBackgroundBlueF() - 0.3f), (float)Config.getSkin().getBackgroundAlphaF());
    }

    private void bindBackground() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceHelper.getBackgroundTexture());
    }

    @Nullable
    protected String getSplash() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        if (day == 12 && month == 24) {
            return "Merry X-mas!";
        }
        if (day == 1 && month == 1) {
            return "Happy new year!";
        }
        if (day == 10 && month == 31) {
            return "OOoooOOOoooo! Spooky!";
        }
        if (day == 3 && month == 28) {
            return calendar.get(1) - 2013 + " Years of World Handler!";
        }
        return null;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ActionHelper.tryRun(() -> {
            int x;
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            if (Config.getSkin().drawBackground()) {
                super.func_146276_q_();
            }
            this.defaultColor();
            this.bindBackground();
            this.func_73729_b(backgroundX, backgroundY, 0, 0, this.bgTextureWidth, this.bgTextureHeight);
            this.forEachTab((index, xOffset) -> {
                int color;
                int fHeight;
                int yOffset;
                Content tab = this.content.getCategory().getContent((int)index);
                if (this.content.getActiveContent().equals(tab)) {
                    yOffset = -22;
                    fHeight = 25;
                    color = 0xFFFFFF;
                    this.defaultColor();
                } else {
                    yOffset = -20;
                    fHeight = 20;
                    color = 0xE0E0E0;
                    this.darkColor();
                }
                this.bindBackground();
                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + yOffset, 0, 0, (int)Math.ceil(this.tabHalf), fHeight);
                this.func_73729_b((int)((double)backgroundX + this.tabHalf + xOffset), backgroundY + yOffset, this.bgTextureWidth - (int)Math.ceil(this.tabHalf), 0, (int)Math.ceil(this.tabHalf), fHeight);
                if (!Config.getSkin().sharpEdges()) {
                    if (this.content.getActiveContent().equals(tab)) {
                        int x;
                        int factor;
                        if (index < this.tabSize - 1 || this.tabSize == 1) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b((int)((double)backgroundX + this.tabWidth + xOffset - (double)x - 1.0), backgroundY + x + 1, (int)(this.tabWidth - (double)x - 1.0), x + 1, x + 1, 1);
                            }
                        }
                        if (index > 0) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + x + 1, xOffset.intValue(), x + 1, x + 1, 1);
                            }
                        }
                        int width = (int)(this.tabWidth - 3.0);
                        int interval = 5;
                        if (index == 0) {
                            for (int x2 = 0; x2 < width; x2 += interval) {
                                this.defaultColor(1.0f - (float)x2 / ((float)width + 5.0f * (float)interval));
                                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + yOffset + fHeight + x2 / interval, 0, fHeight, width - x2, 1);
                            }
                        }
                        if (index == this.tabSize - 1 && this.tabSize > 1) {
                            int offset = 3;
                            for (int x3 = 0; x3 < width; x3 += interval) {
                                this.defaultColor(1.0f - (float)x3 / ((float)width + 5.0f * (float)interval));
                                this.func_73729_b((int)((double)backgroundX + Math.ceil(xOffset) + (double)x3 + (double)offset), backgroundY + yOffset + fHeight + x3 / interval, this.bgTextureWidth - width + x3, fHeight, width - x3, 1);
                            }
                        }
                    } else {
                        int x;
                        int factor;
                        if (index == 0) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b(backgroundX, backgroundY + x, 0, fHeight, factor - x, 1);
                            }
                        }
                        if (index == this.tabSize - 1) {
                            factor = 3;
                            for (x = 0; x < factor + 1; ++x) {
                                this.func_73729_b(backgroundX + this.bgTextureWidth - x, backgroundY + factor - x, this.bgTextureWidth - x, fHeight, x, 1);
                            }
                        }
                    }
                }
                this.func_73732_a(this.field_146289_q, ChatFormatting.UNDERLINE + tab.getTabTitle(), (int)((double)backgroundX + this.tabHalf + xOffset), backgroundY - 13, color);
            });
            this.defaultColor();
            String label = "1.13.2-2.4";
            int hexAlpha = 0x33000000;
            int color = Config.getSkin().getLabelColor() + 0x33000000;
            int versionWidth = this.field_146294_l - this.field_146289_q.func_78256_a("1.13.2-2.4") - 2;
            int versionHeight = this.field_146295_m - 10;
            this.field_146289_q.func_211126_b("1.13.2-2.4", (float)versionWidth, (float)versionHeight, color);
            int maxWidth = this.bgTextureWidth - 7 - 2 - this.field_146289_q.func_78256_a(WorldHandler.USERNAME) - 2 - this.getWatchOffset() - 7;
            this.field_146289_q.func_211126_b(TextFormatting.shortenString(this.content.getTitle(), maxWidth, this.field_146289_q), (float)(backgroundX + 7), (float)(backgroundY + 7), Config.getSkin().getLabelColor());
            if (this.content.getHeadline() != null) {
                if (this.content.getHeadline().length > 0) {
                    this.field_146289_q.func_211126_b(this.content.getHeadline()[0], (float)(backgroundX + 8), (float)(backgroundY + 22), Config.getSkin().getHeadlineColor());
                }
                if (this.content.getHeadline().length > 1) {
                    this.field_146289_q.func_211126_b(this.content.getHeadline()[1], (float)(backgroundX + 126), (float)(backgroundY + 22), Config.getSkin().getHeadlineColor());
                }
            }
            String username = WorldHandler.USERNAME.isEmpty() && !this.nameField.func_146206_l() ? I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0]) : WorldHandler.USERNAME;
            this.field_146289_q.func_211126_b(username, (float)(backgroundX + 232 - this.field_146289_q.func_78256_a(username)), (float)(backgroundY + 7), Config.getSkin().getLabelColor());
            if (Config.getSettings().watch()) {
                int watchX = backgroundX + 233;
                int watchY = backgroundY + 5;
                UtilRender.drawWatchIntoGui((Gui)this, watchX, watchY, Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f(), Config.getSettings().smoothWatch());
                if (Config.getSettings().tooltips() && mouseX >= watchX && mouseX <= watchX + 9 && mouseY >= watchY && mouseY <= watchY + 9) {
                    GuiUtils.drawHoveringText(Arrays.asList(TextFormatting.formatWorldTime(Minecraft.func_71410_x().field_71441_e.func_72820_D())), (int)mouseX, (int)(mouseY + 9), (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (FontRenderer)this.field_146289_q);
                    GlStateManager.func_179140_f();
                }
            }
            for (x = 0; x < this.field_146292_n.size(); ++x) {
                ((GuiButton)this.field_146292_n.get(x)).func_194828_a(mouseX, mouseY, partialTicks);
            }
            for (x = 0; x < this.field_146293_o.size(); ++x) {
                ((GuiLabel)this.field_146293_o.get(x)).func_194997_a(mouseX, mouseY, partialTicks);
            }
            this.content.drawScreen(this, this.getContentX(), this.getContentY(), mouseX, mouseY, partialTicks);
            for (IElement element : this.elements) {
                element.draw(mouseX, mouseY, partialTicks);
            }
            if (Config.getSettings().commandSyntax() && this.syntaxField != null) {
                this.syntaxField.func_195608_a(mouseX, mouseY, partialTicks);
            }
            if (this.splash != null) {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)(backgroundX + 212), (float)(backgroundY + 15), (float)0.0f);
                GlStateManager.func_179114_b((float)17.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float scale = 1.1f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
                scale = scale * 100.0f / (float)this.field_146289_q.func_78256_a(this.splash);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.func_73732_a(this.field_146289_q, this.splash, 0, (int)scale, 0xFFFF00);
                GlStateManager.func_179121_F();
            }
            if (Config.getSettings().tooltips()) {
                for (GuiButton button : this.field_146292_n) {
                    if (!(button instanceof GuiButtonTooltip)) continue;
                    ((GuiButtonTooltip)button).renderTooltip(mouseX, mouseY);
                }
            }
            if (mouseX >= versionWidth && mouseY >= versionHeight) {
                GuiUtils.drawHoveringText(Arrays.asList("1.13.2-2.4"), (int)(versionWidth - 12), (int)(versionHeight + 12), (int)(this.field_146294_l + this.field_146289_q.func_78256_a("1.13.2-2.4")), (int)(this.field_146295_m + 10), (int)this.field_146294_l, (FontRenderer)this.field_146289_q);
            }
        });
    }

    public boolean charTyped(char charTyped, int keyCode) {
        if (this.nameField.func_146206_l()) {
            this.nameField.func_146202_e();
        }
        return super.charTyped(charTyped, keyCode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int keyCode) {
        if (this.nameField.func_146206_l()) {
            this.nameField.func_146202_e();
        }
        return super.mouseClicked(mouseX, mouseY, keyCode);
    }

    public void func_146281_b() {
        ActionHelper.tryRun(this.content::onGuiClosed);
    }

    public boolean func_73868_f() {
        return Config.getSettings().pause();
    }

    @Override
    public String getPlayer() {
        return WorldHandler.USERNAME;
    }

    @Override
    public Content getContent() {
        return this.content;
    }
}

