/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content;

import exopandora.worldhandler.gui.content.IContent;
import exopandora.worldhandler.gui.content.impl.ContentAdvancements;
import exopandora.worldhandler.gui.content.impl.ContentButcher;
import exopandora.worldhandler.gui.content.impl.ContentButcherSettings;
import exopandora.worldhandler.gui.content.impl.ContentChangeWorld;
import exopandora.worldhandler.gui.content.impl.ContentContainers;
import exopandora.worldhandler.gui.content.impl.ContentContinue;
import exopandora.worldhandler.gui.content.impl.ContentCustomItem;
import exopandora.worldhandler.gui.content.impl.ContentEditBlocks;
import exopandora.worldhandler.gui.content.impl.ContentEnchantment;
import exopandora.worldhandler.gui.content.impl.ContentExperience;
import exopandora.worldhandler.gui.content.impl.ContentGamerules;
import exopandora.worldhandler.gui.content.impl.ContentMain;
import exopandora.worldhandler.gui.content.impl.ContentMultiplayer;
import exopandora.worldhandler.gui.content.impl.ContentNoteEditor;
import exopandora.worldhandler.gui.content.impl.ContentPlayer;
import exopandora.worldhandler.gui.content.impl.ContentPotions;
import exopandora.worldhandler.gui.content.impl.ContentRecipes;
import exopandora.worldhandler.gui.content.impl.ContentScoreboardObjectives;
import exopandora.worldhandler.gui.content.impl.ContentScoreboardPlayers;
import exopandora.worldhandler.gui.content.impl.ContentScoreboardTeams;
import exopandora.worldhandler.gui.content.impl.ContentSettings;
import exopandora.worldhandler.gui.content.impl.ContentSignEditor;
import exopandora.worldhandler.gui.content.impl.ContentSummon;
import exopandora.worldhandler.gui.content.impl.ContentWorldInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public abstract class Content
extends ForgeRegistryEntry<Content>
implements IContent {
    public static final String NAMESPACE = String.join((CharSequence)"_", "worldhandler", "content");
    public static final IRegistry<Content> REGISTRY = IRegistry.func_212610_a((String)NAMESPACE, (IRegistry)new RegistryNamespacedDefaultedByKey(new ResourceLocation(NAMESPACE, "main")));
    private Map<String, Object> persistence;

    public static void registerContents() {
        Content.registerContent(0, "main", (Content)new ContentMain());
        Content.registerContent(1, "containers", (Content)new ContentContainers());
        Content.registerContent(2, "multiplayer", (Content)new ContentMultiplayer());
        Content.registerContent(3, "summon", (Content)new ContentSummon());
        Content.registerContent(5, "custom_item", (Content)new ContentCustomItem());
        Content.registerContent(4, "enchantment", (Content)new ContentEnchantment());
        Content.registerContent(6, "edit_blocks", (Content)new ContentEditBlocks());
        Content.registerContent(7, "sign_editor", (Content)new ContentSignEditor());
        Content.registerContent(8, "note_editor", (Content)new ContentNoteEditor());
        Content.registerContent(9, "world", (Content)new ContentWorldInfo());
        Content.registerContent(10, "gamerules", (Content)new ContentGamerules());
        Content.registerContent(11, "recipes", (Content)new ContentRecipes());
        Content.registerContent(12, "player", (Content)new ContentPlayer());
        Content.registerContent(13, "experience", (Content)new ContentExperience());
        Content.registerContent(14, "advancements", (Content)new ContentAdvancements());
        Content.registerContent(15, "scoreboard_objectives", (Content)new ContentScoreboardObjectives());
        Content.registerContent(16, "scoreboard_teams", (Content)new ContentScoreboardTeams());
        Content.registerContent(17, "scoreboard_players", (Content)new ContentScoreboardPlayers());
        Content.registerContent(18, "change_world", (Content)new ContentChangeWorld());
        Content.registerContent(19, "continue", (Content)new ContentContinue());
        Content.registerContent(20, "potions", (Content)new ContentPotions());
        Content.registerContent(21, "butcher", (Content)new ContentButcher());
        Content.registerContent(22, "butcher_settings", (Content)new ContentButcherSettings());
        Content.registerContent(23, "settings", (Content)new ContentSettings());
    }

    private static void registerContent(int id, String textualID, Content content) {
        Content.registerContent(id, new ResourceLocation("worldhandler", textualID), content);
    }

    private static void registerContent(int id, ResourceLocation textualID, Content content) {
        REGISTRY.func_177775_a(id, textualID, (Object)content);
    }

    public <T> T getPersistence(String id, Supplier<T> supplier) {
        if (this.persistence == null) {
            this.persistence = new HashMap<String, Object>();
        }
        if (this.persistence.containsKey(id)) {
            return (T)this.persistence.get(id);
        }
        T object = supplier.get();
        this.persistence.put(id, object);
        return object;
    }
}

