/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderAdvancement;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.logic.ILogicMapped;
import exopandora.worldhandler.gui.logic.ILogicPageList;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.util.ActionHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentAdvancements
extends Content {
    private final BuilderAdvancement builderAdvancement = new BuilderAdvancement(BuilderAdvancement.EnumMode.values()[0]);
    private final List<BuilderAdvancement.EnumMode> modes = Arrays.stream(BuilderAdvancement.EnumMode.values()).filter(mode -> !mode.equals((Object)BuilderAdvancement.EnumMode.EVERYTHING)).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderAdvancement;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        List advancements = new AdvancementManager().func_195438_b().stream().filter(advancement -> advancement.func_192068_c() != null).collect(Collectors.toList());
        ElementPageList<Advancement> list = new ElementPageList<Advancement>(x, y, advancements, 114, 20, 3, container, new ILogicPageList<Advancement>(){

            @Override
            public String translate(Advancement item) {
                return item.func_192068_c().func_192297_a().getString();
            }

            @Override
            public String toTooltip(Advancement item) {
                return item.func_192067_g().toString();
            }

            @Override
            public void onClick(Advancement item) {
                ContentAdvancements.this.builderAdvancement.setAdvancement(item.func_192067_g());
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, Advancement item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "advancement";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(new GuiButtonList<BuilderAdvancement.EnumMode>(x + 118, y, this.modes, 114, 20, container, new ILogicMapped<BuilderAdvancement.EnumMode>(){

            @Override
            public String translate(BuilderAdvancement.EnumMode item) {
                return I18n.func_135052_a((String)("gui.worldhandler.advancements." + item.toString()), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(BuilderAdvancement.EnumMode item) {
                return item.toString();
            }

            @Override
            public void onClick(BuilderAdvancement.EnumMode item) {
                ContentAdvancements.this.builderAdvancement.setMode(item);
            }

            @Override
            public String getId() {
                return "mode";
            }
        }));
        container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.advancements.grant", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderAdvancement.getBuilderForAction(BuilderAdvancement.EnumActionType.GRANT))));
        container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.advancements.revoke", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderAdvancement.getBuilderForAction(BuilderAdvancement.EnumActionType.REVOKE))));
        container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, ChatFormatting.RED + I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.CONTINUE.withBuilder(this.builderAdvancement.getBuilder(BuilderAdvancement.EnumActionType.REVOKE, BuilderAdvancement.EnumMode.EVERYTHING)).withParent(Contents.ADVANCEMENTS)))));
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.player.advancements", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.player.advancements", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.ADVANCEMENTS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderAdvancement.setPlayer(username);
    }
}

