/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderButcher;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.abstr.ContentChild;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentButcher
extends ContentChild {
    private GuiTextFieldTooltip radiusField;
    private String radius;
    private final BuilderButcher builderButcher = new BuilderButcher();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderButcher;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.radiusField = new GuiTextFieldTooltip(x + 58, y + 12, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.radius", (Object[])new Object[0]));
        this.radiusField.func_200675_a(string -> {
            if (string == null) {
                return false;
            }
            if (!string.isEmpty()) {
                try {
                    Integer.parseInt(string);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        });
        this.radiusField.func_146180_a(this.radius);
        this.radiusField.func_195609_a((id, text) -> {
            this.radius = text;
            if (!this.radius.isEmpty()) {
                this.builderButcher.setDistance(Integer.valueOf(this.radius));
            } else {
                this.builderButcher.setDistance(0);
            }
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(this.radiusField);
        container.add(new GuiButtonBase(x + 58, y + 36, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.configure", (Object[])new Object[0]), () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.BUTCHER_SETTINGS.withParent(Contents.BUTCHER)))));
        GuiButtonBase slaughter = new GuiButtonBase(2, x + 58, y + 60, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.slaughter", (Object[])new Object[0]), () -> {
            for (ResourceLocation entry : Config.getButcher().getEntities()) {
                CommandHelper.sendCommand(new BuilderButcher(entry, (int)Integer.valueOf(this.radius)));
            }
        });
        container.add(slaughter);
        slaughter.field_146124_l = this.radius != null && !this.radius.isEmpty() && !Config.CLIENT.getButcher().getEntities().isEmpty();
    }

    @Override
    public void tick(Container container) {
        this.radiusField.func_146178_a();
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.radiusField.func_195608_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.butcher", (Object[])new Object[0]);
    }
}

