/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentChild;
import exopandora.worldhandler.gui.logic.ILogicPageList;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.util.ActionHandler;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentButcherSettings
extends ContentChild {
    private ResourceLocation entity;

    @Override
    public void initGui(final Container container, int x, int y) {
        List list = ForgeRegistries.ENTITIES.getValues().stream().filter(EntityType::func_200720_b).collect(Collectors.toList());
        ElementPageList entities = new ElementPageList(x, y, list, 114, 20, 3, container, new ILogicPageList<EntityType<?>>(){

            @Override
            public String translate(EntityType<?> item) {
                TextFormatting color = TextFormatting.RED;
                if (Config.CLIENT.getButcher().containsEntity(item.getRegistryName())) {
                    color = TextFormatting.GREEN;
                }
                return color + I18n.func_135052_a((String)item.func_210760_d(), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(EntityType<?> item) {
                return item.getRegistryName().toString();
            }

            @Override
            public void onClick(EntityType<?> item) {
                ContentButcherSettings.this.entity = item.getRegistryName();
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, EntityType<?> item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "entities";
            }
        });
        container.add(entities);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]), () -> {
            Config.CLIENT.getButcher().addEntity(this.entity);
            container.initButtons();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.disable", (Object[])new Object[0]), () -> {
            Config.CLIENT.getButcher().removeEntity(this.entity);
            container.initButtons();
        });
        container.add(button2);
        boolean contains = Config.CLIENT.getButcher().containsEntity(this.entity);
        button1.field_146124_l = !contains;
        button2.field_146124_l = contains;
    }

    @Override
    public String getTitle() {
        return this.parent.getTitle();
    }
}

