/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderClone;
import exopandora.worldhandler.builder.impl.BuilderFill;
import exopandora.worldhandler.builder.impl.BuilderWH;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.logic.ILogicMapped;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.helper.ResourceHelper;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentEditBlocks
extends Content {
    private GuiTextFieldTooltip x1Field;
    private GuiTextFieldTooltip y1Field;
    private GuiTextFieldTooltip z1Field;
    private GuiTextFieldTooltip x2Field;
    private GuiTextFieldTooltip y2Field;
    private GuiTextFieldTooltip z2Field;
    private GuiTextFieldTooltip block1Field;
    private GuiTextFieldTooltip block2Field;
    private final BuilderFill builderFill = BlockHelper.addPositionObservers(new BuilderFill(), builder -> builder::setPosition1, builder -> builder::setPosition2);
    private final BuilderClone builderClone = BlockHelper.addPositionObservers(new BuilderClone(), builder -> builder::setPosition1, builder -> builder::setPosition2);
    private final BuilderWH builderWH = new BuilderWH();
    private String block1;
    private String block2;
    private String selectedPage = "coordinates";

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (this.selectedPage.equals("coordinates")) {
            return this.builderWH;
        }
        if (this.selectedPage.equals("fill") || this.selectedPage.equals("replace")) {
            return this.builderFill;
        }
        if (this.selectedPage.equals("clone")) {
            return this.builderClone;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.x1Field = new GuiTextFieldTooltip(x + 118, y, 55, 20);
        this.x1Field.func_200675_a((Predicate)this.getCoordinatePredicate("X1"));
        this.x1Field.func_146180_a("X1: " + BlockHelper.getPos1().func_177958_n());
        this.x1Field.func_195609_a((id, text) -> BlockHelper.setPos1(BlockHelper.setX(BlockHelper.getPos1(), this.parseCoordinate((String)text))));
        this.y1Field = new GuiTextFieldTooltip(x + 118, y + 24, 55, 20);
        this.y1Field.func_200675_a((Predicate)this.getCoordinatePredicate("Y1"));
        this.y1Field.func_146180_a("Y1: " + BlockHelper.getPos1().func_177956_o());
        this.y1Field.func_195609_a((id, text) -> BlockHelper.setPos1(BlockHelper.setY(BlockHelper.getPos1(), this.parseCoordinate((String)text))));
        this.z1Field = new GuiTextFieldTooltip(x + 118, y + 48, 55, 20);
        this.z1Field.func_200675_a((Predicate)this.getCoordinatePredicate("Z1"));
        this.z1Field.func_146180_a("Z1: " + BlockHelper.getPos1().func_177952_p());
        this.z1Field.func_195609_a((id, text) -> BlockHelper.setPos1(BlockHelper.setZ(BlockHelper.getPos1(), this.parseCoordinate((String)text))));
        this.x2Field = new GuiTextFieldTooltip(x + 118 + 59, y, 55, 20);
        this.x2Field.func_200675_a((Predicate)this.getCoordinatePredicate("X2"));
        this.x2Field.func_146180_a("X2: " + BlockHelper.getPos2().func_177958_n());
        this.x2Field.func_195609_a((id, text) -> BlockHelper.setPos2(BlockHelper.setX(BlockHelper.getPos2(), this.parseCoordinate((String)text))));
        this.y2Field = new GuiTextFieldTooltip(x + 118 + 59, y + 24, 55, 20);
        this.y2Field.func_200675_a((Predicate)this.getCoordinatePredicate("Y2"));
        this.y2Field.func_146180_a("Y2: " + BlockHelper.getPos2().func_177956_o());
        this.y2Field.func_195609_a((id, text) -> BlockHelper.setPos2(BlockHelper.setY(BlockHelper.getPos2(), this.parseCoordinate((String)text))));
        this.z2Field = new GuiTextFieldTooltip(x + 118 + 59, y + 48, 55, 20);
        this.z2Field.func_200675_a((Predicate)this.getCoordinatePredicate("Z2"));
        this.z2Field.func_146180_a("Z2: " + BlockHelper.getPos2().func_177952_p());
        this.z2Field.func_195609_a((id, text) -> BlockHelper.setPos2(BlockHelper.setZ(BlockHelper.getPos2(), this.parseCoordinate((String)text))));
        this.block1Field = new GuiTextFieldTooltip(x + 118, y, 114, 20, this.selectedPage.equals("fill") ? I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill.block_id_to_fill", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace.block_id_replace", (Object[])new Object[0]));
        this.block1Field.func_200675_a((Predicate)Predicates.notNull());
        this.block1Field.func_146180_a(this.block1);
        this.block1Field.func_195609_a((id, text) -> {
            this.block1 = text;
            this.builderFill.setBlock1(this.block1);
            container.initButtons();
        });
        this.block2Field = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace.block_id_place", (Object[])new Object[0]));
        this.block2Field.func_200675_a((Predicate)Predicates.notNull());
        this.block2Field.func_146180_a(this.block2);
        this.block2Field.func_195609_a((id, text) -> {
            this.block2 = text;
            this.builderFill.setBlock2(this.block2);
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.coordinates", (Object[])new Object[0]), () -> {
            this.selectedPage = "coordinates";
            container.func_73866_w_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill", (Object[])new Object[0]), () -> {
            this.selectedPage = "fill";
            container.func_73866_w_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace", (Object[])new Object[0]), () -> {
            this.selectedPage = "replace";
            container.func_73866_w_();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.clone", (Object[])new Object[0]), () -> {
            this.selectedPage = "clone";
            container.func_73866_w_();
        });
        container.add(button4);
        int yOffset1 = 0;
        int yOffset2 = 0;
        int xOffset2 = 0;
        int width1 = 0;
        int width2 = 0;
        if (this.selectedPage.equals("coordinates")) {
            button1.field_146124_l = false;
            yOffset1 = 72;
            yOffset2 = 72;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            container.add(this.x1Field);
            container.add(this.y1Field);
            container.add(this.z1Field);
            container.add(this.x2Field);
            container.add(this.y2Field);
            container.add(this.z2Field);
        } else if (this.selectedPage.equals("fill")) {
            button2.field_146124_l = false;
            yOffset1 = 24;
            yOffset2 = 48;
            width1 = 114;
            width2 = 114;
            xOffset2 = 0;
            container.add(this.block1Field);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderFill.getBuilderForFill()));
            container.add(button1);
            button1.field_146124_l = ResourceHelper.isRegistered(this.builderFill.getBlock1(), ForgeRegistries.BLOCKS);
        } else if (this.selectedPage.equals("replace")) {
            button3.field_146124_l = false;
            yOffset1 = 48;
            yOffset2 = 48;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            container.add(this.block1Field);
            container.add(this.block2Field);
            button1 = new GuiButtonBase(8, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderFill.getBuilderForReplace()));
            container.add(button1);
            button1.field_146124_l = ResourceHelper.isRegistered(this.builderFill.getBlock1(), ForgeRegistries.BLOCKS) && ResourceHelper.isRegistered(this.builderFill.getBlock2(), ForgeRegistries.BLOCKS);
        } else if (this.selectedPage.equals("clone")) {
            button4.field_146124_l = false;
            yOffset1 = 24;
            yOffset2 = 48;
            width1 = 114;
            width2 = 114;
            xOffset2 = 0;
            container.add(new GuiButtonList<BuilderClone.EnumMask>(x + 118, y, Arrays.asList(BuilderClone.EnumMask.values()), 114, 20, container, new ILogicMapped<BuilderClone.EnumMask>(){

                @Override
                public String translate(BuilderClone.EnumMask item) {
                    return I18n.func_135052_a((String)("gui.worldhandler.edit_blocks.clone.mode." + item.toString()), (Object[])new Object[0]);
                }

                @Override
                public String toTooltip(BuilderClone.EnumMask item) {
                    return item.toString();
                }

                @Override
                public void onClick(BuilderClone.EnumMask item) {
                    ContentEditBlocks.this.builderClone.setMask(item);
                }

                @Override
                public String getId() {
                    return "mask";
                }
            }));
            container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.clone", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderClone)));
        }
        container.add(new GuiButtonBase(x + 118, y + yOffset1, width1, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.pos.set_pos_1", (Object[])new Object[0]), () -> {
            BlockHelper.setPos1(BlockHelper.getFocusedBlockPos());
            container.func_73866_w_();
        }));
        container.add(new GuiButtonBase(x + 118 + xOffset2, y + yOffset2, width2, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.pos.set_pos_2", (Object[])new Object[0]), () -> {
            BlockHelper.setPos2(BlockHelper.getFocusedBlockPos());
            container.func_73866_w_();
        }));
    }

    @Override
    public void tick(Container container) {
        if (this.selectedPage.equals("coordinates")) {
            this.x1Field.func_146178_a();
            this.y1Field.func_146178_a();
            this.z1Field.func_146178_a();
            this.x2Field.func_146178_a();
            this.y2Field.func_146178_a();
            this.z2Field.func_146178_a();
        } else if (this.selectedPage.equals("fill")) {
            this.block1Field.func_146178_a();
        } else if (this.selectedPage.equals("replace")) {
            this.block1Field.func_146178_a();
            this.block2Field.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedPage.equals("coordinates")) {
            this.x1Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.y1Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.z1Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.x2Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.y2Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.z2Field.func_195608_a(mouseX, mouseY, partialTicks);
        } else if (this.selectedPage.equals("fill")) {
            this.block1Field.func_195608_a(mouseX, mouseY, partialTicks);
        } else if (this.selectedPage.equals("replace")) {
            this.block1Field.func_195608_a(mouseX, mouseY, partialTicks);
            this.block2Field.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    private com.google.common.base.Predicate<String> getCoordinatePredicate(String coordinate) {
        return string -> string.matches(coordinate + ": [-]?[0-9]*");
    }

    private int parseCoordinate(String input) {
        String[] split;
        if (input != null && (split = input.split(": ", 2))[1].matches("[-]?[0-9]+")) {
            return Integer.parseInt(split[1]);
        }
        return 0;
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.blocks.edit_blocks", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.blocks.edit_blocks", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.EDIT_BLOCKS;
    }
}

