/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderEnchantment;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.logic.ILogicPageList;
import exopandora.worldhandler.gui.logic.LogicSliderSimple;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.util.ActionHandler;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentEnchantment
extends Content {
    private final BuilderEnchantment builderEnchantment = new BuilderEnchantment();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderEnchantment;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        ElementPageList<Enchantment> enchantments = new ElementPageList<Enchantment>(x, y, new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues()), 114, 20, 3, container, new ILogicPageList<Enchantment>(){

            @Override
            public String translate(Enchantment item) {
                return I18n.func_135052_a((String)item.func_77320_a(), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(Enchantment item) {
                return item.getRegistryName().toString();
            }

            @Override
            public void onClick(Enchantment item) {
                ContentEnchantment.this.builderEnchantment.setEnchantment(item);
                ContentEnchantment.this.builderEnchantment.setLevel(1);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, Enchantment item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "enchantments";
            }
        });
        container.add(enchantments);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        container.add(new GuiSlider(x + 118, y + 24, 114, 20, 1.0, ((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.builderEnchantment.getEnchantment())).func_77325_b(), 1.0, container, new LogicSliderSimple("enchantment", I18n.func_135052_a((String)"gui.worldhandler.items.enchantment.level", (Object[])new Object[0]), value -> this.builderEnchantment.setLevel((int)value))));
        container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.enchantment.enchant", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderEnchantment)));
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.items.enchantment", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.items.enchantment", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.ENCHANTMENT;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderEnchantment.setPlayer(username);
    }
}

