/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderGamerule;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.logic.ILogicPageList;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.util.ActionHandler;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentGamerules
extends Content {
    private GuiTextFieldTooltip valueField;
    private boolean booleanValue;
    private String value;
    private final BuilderGamerule builderGamerule = new BuilderGamerule();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderGamerule;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        this.valueField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.value", (Object[])new Object[0]));
        this.valueField.func_200675_a((Predicate)Predicates.notNull());
        this.valueField.func_146180_a(this.value);
        this.valueField.func_146202_e();
        this.valueField.func_195609_a((id, text) -> {
            this.value = text;
            this.builderGamerule.setValue(this.value);
        });
        ElementPageList<String> rules = new ElementPageList<String>(x, y, new ArrayList(GameRules.func_196231_c().keySet()), 114, 20, 3, container, new ILogicPageList<String>(){

            @Override
            public String translate(String item) {
                return I18n.func_135052_a((String)("gui.worldhandler.gamerules.rule." + item), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(String item) {
                return item;
            }

            @Override
            public void onClick(String item) {
                ContentGamerules.this.builderGamerule.setRule(item);
                ContentGamerules.this.booleanValue = ((GameRules.ValueDefinition)GameRules.func_196231_c().get(item)).func_199594_b().equals((Object)GameRules.ValueType.BOOLEAN_VALUE);
                if (ContentGamerules.this.booleanValue) {
                    ContentGamerules.this.builderGamerule.setValue(null);
                } else {
                    ContentGamerules.this.builderGamerule.setValue(ContentGamerules.this.value);
                }
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, String item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "gamerules";
            }
        });
        container.add(rules);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        if (this.booleanValue) {
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(true)))));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.disable", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(false)))));
        } else {
            container.add(this.valueField);
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderGamerule)));
        }
    }

    @Override
    public void tick(Container container) {
        if (!this.booleanValue) {
            this.valueField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.booleanValue) {
            this.valueField.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.world.gamerules", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.world.gamerules", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.GAMERULES;
    }
}

