/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderGeneric;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderPlayer;
import exopandora.worldhandler.builder.impl.BuilderPlayerReason;
import exopandora.worldhandler.builder.impl.BuilderWhitelist;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonIcon;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentMultiplayer
extends Content {
    private GuiTextFieldTooltip playerField;
    private GuiTextFieldTooltip reasonField;
    private int shiftDown = 0;
    private String selected = "kickBan";
    private final BuilderPlayerReason builderKick = new BuilderPlayerReason("kick");
    private final BuilderPlayerReason builderBan = new BuilderPlayerReason("ban");
    private final BuilderPlayer builderPardon = new BuilderPlayer("pardon");
    private final BuilderPlayer builderOp = new BuilderPlayer("op");
    private final BuilderPlayer builderDeop = new BuilderPlayer("deop");
    private final BuilderGeneric builderSaveAll = new BuilderGeneric("save-all", new String[0]);
    private final BuilderGeneric builderSaveOn = new BuilderGeneric("save-on", new String[0]);
    private final BuilderGeneric builderSaveOff = new BuilderGeneric("save-off", new String[0]);
    private final BuilderGeneric builderStop = new BuilderGeneric("stop", new String[0]);
    private final BuilderWhitelist builderWhitelist = new BuilderWhitelist();
    private final BuilderMultiCommand builderKickBan = new BuilderMultiCommand(this.builderKick, this.builderBan);
    private final BuilderMultiCommand builderPermissions = new BuilderMultiCommand(this.builderOp, this.builderDeop);
    private final BuilderMultiCommand builderRuntime = new BuilderMultiCommand(this.builderSaveAll, this.builderSaveOn, this.builderSaveOff, this.builderStop);

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (this.selected.equals("kickBan")) {
            return this.builderKickBan;
        }
        if (this.selected.equals("pardon")) {
            return this.builderPardon;
        }
        if (this.selected.equals("permissions")) {
            return this.builderPermissions;
        }
        if (this.selected.equals("runtime")) {
            return this.builderRuntime;
        }
        if (this.selected.equals("whitelist")) {
            return this.builderWhitelist;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.playerField = new GuiTextFieldTooltip(x + 118, y + this.shiftDown, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.username", (Object[])new Object[0]));
        this.playerField.func_200675_a((Predicate)Predicates.notNull());
        this.playerField.func_146195_b(false);
        this.playerField.func_146180_a(this.builderKick.getPlayer());
        this.playerField.func_146203_f(16);
        this.playerField.func_195609_a((id, text) -> {
            this.setPlayer(this.playerField.func_146179_b());
            container.initButtons();
        });
        this.reasonField = new GuiTextFieldTooltip(x + 118, y + 24 + this.shiftDown, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.kick_ban.reason", (Object[])new Object[0]));
        this.reasonField.func_200675_a((Predicate)Predicates.notNull());
        this.reasonField.func_146195_b(false);
        this.reasonField.func_146180_a(this.builderKick.getReason());
        this.reasonField.func_195609_a((id, text) -> {
            this.setReason(this.reasonField.func_146179_b());
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.kick", (Object[])new Object[0]) + " / " + I18n.func_135052_a((String)"gui.worldhandler.multiplayer.ban", (Object[])new Object[0]), () -> {
            this.selected = "kickBan";
            this.shiftDown = 0;
            container.func_73866_w_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.pardon", (Object[])new Object[0]), () -> {
            this.selected = "pardon";
            this.shiftDown = 24;
            container.func_73866_w_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.permissions", (Object[])new Object[0]), () -> {
            this.selected = "permissions";
            this.shiftDown = 12;
            container.func_73866_w_();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.runtime", (Object[])new Object[0]), () -> {
            this.selected = "runtime";
            this.shiftDown = 0;
            container.func_73866_w_();
        });
        container.add(button4);
        GuiButtonBase button5 = new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist", (Object[])new Object[0]), () -> {
            this.selected = "whitelist";
            this.shiftDown = 0;
            container.func_73866_w_();
        });
        container.add(button5);
        if (this.selected.equals("kickBan")) {
            container.add(this.playerField);
            container.add(this.reasonField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.kick", (Object[])new Object[0]), this.builderKick.toActualCommand(), () -> CommandHelper.sendCommand(this.builderKick));
            container.add(button6);
            GuiButtonTooltip button7 = new GuiButtonTooltip(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.ban", (Object[])new Object[0]), this.builderBan.toActualCommand(), () -> CommandHelper.sendCommand(this.builderBan));
            container.add(button7);
            if (this.playerField.func_146179_b().isEmpty()) {
                button6.field_146124_l = false;
                button7.field_146124_l = false;
            }
            button1.field_146124_l = false;
        } else if (this.selected.equals("pardon")) {
            container.add(this.playerField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.pardon", (Object[])new Object[0]), this.builderPardon.toActualCommand(), () -> CommandHelper.sendCommand(this.builderPardon));
            container.add(button6);
            if (this.playerField.func_146179_b().isEmpty()) {
                button6.field_146124_l = false;
            }
            button2.field_146124_l = false;
        } else if (this.selected.equals("permissions")) {
            container.add(this.playerField);
            GuiButtonTooltip button6 = new GuiButtonTooltip(x + 118, y + 24 + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.permissions.give", (Object[])new Object[0]), this.builderOp.toActualCommand(), () -> CommandHelper.sendCommand(this.builderOp));
            container.add(button6);
            GuiButtonTooltip button7 = new GuiButtonTooltip(x + 118, y + 48 + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.permissions.take", (Object[])new Object[0]), this.builderDeop.toActualCommand(), () -> CommandHelper.sendCommand(this.builderDeop));
            container.add(button7);
            if (this.playerField.func_146179_b().isEmpty()) {
                button6.field_146124_l = false;
                button7.field_146124_l = false;
            }
            button3.field_146124_l = false;
        } else if (this.selected.equals("runtime")) {
            container.add(new GuiButtonTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.runtime.save_world", (Object[])new Object[0]), this.builderSaveAll.toActualCommand(), () -> CommandHelper.sendCommand(this.builderSaveAll)));
            container.add(new GuiButtonTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.runtime.autosave", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0])}), this.builderSaveOn.toActualCommand(), () -> CommandHelper.sendCommand(this.builderSaveOn)));
            container.add(new GuiButtonTooltip(x + 118, y + 48, 114, 20, TextFormatting.RED + I18n.func_135052_a((String)"gui.worldhandler.multiplayer.runtime.autosave", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])}), this.builderSaveOff.toActualCommand(), () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.CONTINUE.withBuilder(this.builderSaveOff).withParent(Contents.MULTIPLAYER)))));
            container.add(new GuiButtonTooltip(x + 118, y + 72, 114, 20, TextFormatting.RED + I18n.func_135052_a((String)"gui.worldhandler.multiplayer.runtime.stop_server", (Object[])new Object[0]), this.builderStop.toActualCommand(), () -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.CONTINUE.withBuilder(this.builderStop).withParent(Contents.MULTIPLAYER)))));
            button4.field_146124_l = false;
        } else if (this.selected.equals("whitelist")) {
            container.add(this.playerField);
            GuiButtonBase button6 = new GuiButtonBase(x + 118, y + 24, 44, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist.add", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderWhitelist.getBuilder(BuilderWhitelist.EnumMode.ADD)));
            container.add(button6);
            GuiButtonBase button7 = new GuiButtonBase(x + 118 + 47, y + 24, 44, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist.remove", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderWhitelist.getBuilder(BuilderWhitelist.EnumMode.REMOVE)));
            container.add(button7);
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist.whitelist", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0])}), () -> CommandHelper.sendCommand(this.builderWhitelist.getBuilder(BuilderWhitelist.EnumMode.ON))));
            container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist.whitelist", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])}), () -> CommandHelper.sendCommand(this.builderWhitelist.getBuilder(BuilderWhitelist.EnumMode.OFF))));
            container.add(new GuiButtonIcon(x + 232 - 20, y + 24, 20, 20, EnumIcon.RELOAD, I18n.func_135052_a((String)"gui.worldhandler.multiplayer.whitelist.reload", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderWhitelist.getBuilder(BuilderWhitelist.EnumMode.RELOAD))));
            if (this.playerField.func_146179_b().isEmpty()) {
                button6.field_146124_l = false;
                button7.field_146124_l = false;
            }
            button5.field_146124_l = false;
        }
    }

    @Override
    public void tick(Container container) {
        if (this.selected.equals("kickBan")) {
            this.reasonField.func_146178_a();
        }
        if (!this.selected.equals("runtime")) {
            this.playerField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selected.equals("kickBan")) {
            this.reasonField.func_195608_a(mouseX, mouseY, partialTicks);
        }
        if (!this.selected.equals("runtime")) {
            this.playerField.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    private void setPlayer(String player) {
        this.builderBan.setPlayer(player);
        this.builderKick.setPlayer(player);
        this.builderPardon.setPlayer(player);
        this.builderOp.setPlayer(player);
        this.builderDeop.setPlayer(player);
        this.builderWhitelist.setPlayer(player);
    }

    private void setReason(String reason) {
        this.builderBan.setReason(reason);
        this.builderKick.setReason(reason);
    }

    @Override
    public Category getCategory() {
        return Categories.MAIN;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.multiplayer", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.multiplayer", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.MULTIPLAYER;
    }

    @Override
    public Content getBackContent() {
        return null;
    }
}

