/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderNoteEditor;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonPiano;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.helper.CommandHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentNoteEditor
extends Content {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final BuilderNoteEditor builderNoteEditor = new BuilderNoteEditor();
    private boolean isActive;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.isActive ? this.builderNoteEditor : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.isFocusedBlockEqualTo(Blocks.field_196586_al);
        this.builderNoteEditor.setPosition(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        if (this.isActive) {
            BlockPos pos = this.builderNoteEditor.getBlockPos();
            SoundEvent sound = this.getSoundEvent(pos.func_177977_b());
            container.add(new GuiButtonPiano(x - 3 + 15, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.g", (Object[])new Object[0]), sound, 0.53f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(1))));
            container.add(new GuiButtonPiano(x - 3 + 30, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.a", (Object[])new Object[0]), sound, 0.6f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(3))));
            container.add(new GuiButtonPiano(x - 3 + 45, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.b", (Object[])new Object[0]), sound, 0.67f, GuiButtonPiano.Type.RIGHT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(5))));
            container.add(new GuiButtonPiano(x - 3 + 60, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.c", (Object[])new Object[0]), sound, 0.7f, GuiButtonPiano.Type.LEFT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(6))));
            container.add(new GuiButtonPiano(x - 3 + 75, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.d", (Object[])new Object[0]), sound, 0.8f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(8))));
            container.add(new GuiButtonPiano(x - 3 + 90, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.e", (Object[])new Object[0]), sound, 0.9f, GuiButtonPiano.Type.RIGHT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(10))));
            container.add(new GuiButtonPiano(x - 3 + 105, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.f", (Object[])new Object[0]), sound, 0.95f, GuiButtonPiano.Type.LEFT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(11))));
            container.add(new GuiButtonPiano(x - 3 + 120, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.g", (Object[])new Object[0]), sound, 1.05f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(13))));
            container.add(new GuiButtonPiano(x - 3 + 135, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.a", (Object[])new Object[0]), sound, 1.2f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(15))));
            container.add(new GuiButtonPiano(x - 3 + 150, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.b", (Object[])new Object[0]), sound, 1.32f, GuiButtonPiano.Type.RIGHT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(17))));
            container.add(new GuiButtonPiano(x - 3 + 165, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.c", (Object[])new Object[0]), sound, 1.4f, GuiButtonPiano.Type.LEFT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(18))));
            container.add(new GuiButtonPiano(x - 3 + 180, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.d", (Object[])new Object[0]), sound, 1.6f, GuiButtonPiano.Type.NORMAL, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(20))));
            container.add(new GuiButtonPiano(x - 3 + 195, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.e", (Object[])new Object[0]), sound, 1.8f, GuiButtonPiano.Type.RIGHT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(22))));
            container.add(new GuiButtonPiano(x - 3 + 210, y, 14, 92, I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.f", (Object[])new Object[0]), sound, 1.9f, GuiButtonPiano.Type.LEFT, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(23))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 15, y, 9, 58, "F#", sound, 0.5f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(0))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 30, y, 9, 58, "G#", sound, 0.56f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(2))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 45, y, 9, 58, "A#", sound, 0.63f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(4))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 75, y, 9, 58, "C#", sound, 0.75f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(7))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 90, y, 9, 58, "D#", sound, 0.85f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(9))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 120, y, 9, 58, "F#", sound, 1.0f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(12))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 135, y, 9, 58, "G#", sound, 1.1f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(14))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 150, y, 9, 58, "A#", sound, 1.25f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(16))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 180, y, 9, 58, "C#", sound, 1.5f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(19))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 195, y, 9, 58, "D#", sound, 1.7f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(21))));
            container.add(new GuiButtonPiano(x - 3 - 5 + 225, y, 9, 58, "F#", sound, 2.0f, GuiButtonPiano.Type.BLACK, () -> CommandHelper.sendCommand(this.builderNoteEditor.getBuilderForNote(24))));
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(NOTE);
            container.func_73729_b(x - 1, y - 1, 0, 0, 8, 59);
            container.func_73729_b(x - 1, y - 1 + 59, 0, 59, 13, 35);
            container.func_73729_b(x - 1 + 232 - 5, y - 1, 18, 0, 7, 59);
            container.func_73729_b(x - 1 + 232 - 10, y - 1 + 59, 13, 59, 12, 35);
            container.func_73729_b(x - 1 + 8, y - 1, 0, 94, 219, 1);
            container.func_73729_b(x - 1 + 13, y - 1 + 93, 0, 94, 209, 1);
        } else {
            float scale = 4.0f;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)((float)(container.field_146294_l / 2) - 8.0f * scale), (float)((float)(container.field_146295_m / 2 - 15) - 8.0f * scale), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack((IItemProvider)Blocks.field_196586_al), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            String displayString = I18n.func_135052_a((String)"gui.worldhandler.blocks.note_block_editor.look_at_note_block", (Object[])new Object[]{WorldHandler.KEY_WORLD_HANDLER.getKey().func_197936_a()});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_211126_b(displayString, (float)(x + 116 - fontRenderer.func_78256_a(displayString) / 2), (float)(y + 70), Config.getSkin().getLabelColor());
        }
    }

    private SoundEvent getSoundEvent(BlockPos blockPos) {
        return NoteBlockInstrument.func_208087_a((IBlockState)Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos)).func_208088_a();
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.blocks.note_block_editor", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.blocks.note_block_editor", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.NOTE_EDITOR;
    }
}

