/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderPotionEffect;
import exopandora.worldhandler.builder.impl.BuilderPotionItem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentChild;
import exopandora.worldhandler.gui.logic.ILogicPageList;
import exopandora.worldhandler.gui.logic.LogicSliderSimple;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.util.ActionHandler;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.potion.Potion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ContentPotions
extends ContentChild {
    private int potionPage;
    private final BuilderPotionEffect builderPotion = new BuilderPotionEffect();
    private final BuilderPotionItem builderPotionItem = new BuilderPotionItem();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return new BuilderMultiCommand(this.builderPotion, this.builderPotionItem);
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPotion.getAmplifier() > Config.getSliders().getMaxPotionAmplifier()) {
            this.builderPotion.setAmplifier((byte)Config.getSliders().getMaxPotionAmplifier());
        }
        for (Potion potion : this.builderPotionItem.getPotions()) {
            byte amplifier = this.builderPotionItem.getAmplifier(potion);
            if (!((double)amplifier > Config.getSliders().getMaxPotionAmplifier())) continue;
            this.builderPotionItem.setAmplifier(potion, (byte)Config.getSliders().getMaxPotionAmplifier());
        }
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        ElementPageList<Potion> potions = new ElementPageList<Potion>(x, y, new ArrayList(ForgeRegistries.POTIONS.getValues()), 114, 20, 3, container, new ILogicPageList<Potion>(){

            @Override
            public String translate(Potion item) {
                return I18n.func_135052_a((String)item.func_76393_a(), (Object[])new Object[0]);
            }

            @Override
            public String toTooltip(Potion item) {
                return item.getRegistryName().toString();
            }

            @Override
            public void onClick(Potion item) {
                ContentPotions.this.builderPotion.setEffect(item);
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, String text, Potion item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, text, this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "potions";
            }
        });
        container.add(potions);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonBase button1;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        if (this.potionPage == 0) {
            container.add(new GuiButtonBase(x + 118, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.give", (Object[])new Object[0]), () -> this.next(container)));
            container.add(new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotion.getRemoveCommand());
                container.func_73866_w_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.remove_all", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotion.getClearCommand());
                container.func_73866_w_();
            }));
        } else if (this.potionPage == 1) {
            Potion potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.ambient", (Object[])new Object[]{this.builderPotionItem.getAmbient(potion) ? I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])}), () -> {
                this.builderPotionItem.setAmbient(potion, !this.builderPotionItem.getAmbient(potion));
                container.func_73866_w_();
            }));
            container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{this.builderPotion.getHideParticles() ? I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0])}), () -> {
                this.builderPotion.setHideParticles(!this.builderPotion.getHideParticles());
                this.builderPotionItem.setShowParticles(potion, !this.builderPotionItem.getShowParticles(potion));
                container.func_73866_w_();
            }));
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, Config.getSliders().getMaxPotionAmplifier(), 0.0, container, new LogicSliderSimple("amplifier" + potion.getRegistryName(), I18n.func_135052_a((String)"gui.worldhandler.potions.effect.amplifier", (Object[])new Object[0]), value -> {
                this.builderPotion.setAmplifier(value.byteValue());
                this.builderPotionItem.setAmplifier(potion, value.byteValue());
            })));
        } else if (this.potionPage == 2) {
            Potion potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiSlider(x + 118, y, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("s" + potion.getRegistryName(), I18n.func_135052_a((String)"gui.worldhandler.potion.time.seconds", (Object[])new Object[0]), value -> {
                this.builderPotion.setSeconds((int)value);
                this.builderPotionItem.setSeconds(potion, (int)value);
            })));
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, 59.0, 0.0, container, new LogicSliderSimple("m" + potion.getRegistryName(), I18n.func_135052_a((String)"gui.worldhandler.potion.time.minutes", (Object[])new Object[0]), value -> {
                this.builderPotion.setMinutes((int)value);
                this.builderPotionItem.setMinutes(potion, (int)value);
            })));
            container.add(new GuiSlider(x + 118, y + 48, 114, 20, 0.0, 99.0, 0.0, container, new LogicSliderSimple("h" + potion.getRegistryName(), I18n.func_135052_a((String)"gui.worldhandler.potion.time.hours", (Object[])new Object[0]), value -> {
                this.builderPotion.setHours((int)value);
                this.builderPotionItem.setHours(potion, (int)value);
            })));
        } else if (this.potionPage == 3) {
            boolean enabled;
            button1 = new GuiButtonBase(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotion.getGiveCommand());
                this.potionPage = 0;
                container.func_73866_w_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x + 118, y + 24, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.tipped_arrow", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotionItem.getBuilderForPotion(Items.field_185167_i));
                this.potionPage = 0;
                container.func_73866_w_();
            });
            container.add(button2);
            GuiButtonTooltip button3 = new GuiButtonTooltip(x + 178, y + 24, 55, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.bottle", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotionItem.getBuilderForPotion(Items.field_151068_bn));
                this.potionPage = 0;
                container.func_73866_w_();
            });
            container.add(button3);
            GuiButtonTooltip button4 = new GuiButtonTooltip(x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.splash", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotionItem.getBuilderForPotion(Items.field_185155_bH));
                this.potionPage = 0;
                container.func_73866_w_();
            });
            container.add(button4);
            GuiButtonTooltip button5 = new GuiButtonTooltip(x + 178, y + 48, 55, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.lingering", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPotionItem.getBuilderForPotion(Items.field_185156_bI));
                this.potionPage = 0;
                container.func_73866_w_();
            });
            container.add(button5);
            button1.field_146124_l = enabled = this.builderPotion.getAmplifier() >= 0;
            button2.field_146124_l = enabled;
            button3.field_146124_l = enabled;
            button4.field_146124_l = enabled;
            button5.field_146124_l = enabled;
        }
        if (this.potionPage > 0) {
            container.add(new GuiButtonBase(4, x + 118, y + 72, 56, 20, "<", () -> {
                --this.potionPage;
                container.func_73866_w_();
            }));
            button1 = new GuiButtonBase(5, x + 118 + 60, y + 72, 55, 20, ">", () -> this.next(container));
            container.add(button1);
            button1.field_146124_l = this.potionPage < 3;
        }
    }

    private void next(Container container) {
        ++this.potionPage;
        container.func_73866_w_();
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.potions", (Object[])new Object[0]);
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPotion.setPlayer(username);
        this.builderPotionItem.setPlayer(username);
    }
}

