/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderScoreboardObjectives;
import exopandora.worldhandler.format.EnumColor;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementMultiButtonList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentScoreboard;
import exopandora.worldhandler.gui.logic.ILogicClickList;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.helper.RegistryTranslator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardObjectives
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private String selectedObjective = "create";
    private final BuilderScoreboardObjectives builderObjectives = new BuilderScoreboardObjectives();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderObjectives;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y + (this.selectedObjective.equals("remove") ? 24 : 0), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.func_200675_a((Predicate)Predicates.notNull());
        this.objectField.func_146180_a(ContentScoreboard.getObjective());
        this.objectField.func_195609_a((id, text) -> {
            ContentScoreboard.setObjective(text);
            this.builderObjectives.setObjective(ContentScoreboard.getObjective());
            container.initButtons();
        });
        if (this.selectedObjective.equals("create")) {
            ElementMultiButtonList objectives = new ElementMultiButtonList(x + 118, y + 24, HELPER.getObjectives(), 2, new ILogicClickList(){

                @Override
                public String translate(String key, int depth) {
                    ResourceLocation resource = this.makeResourceLocation(key);
                    if (resource != null) {
                        StatType type = (StatType)IRegistry.field_212634_w.func_212608_b(resource);
                        if (type != null) {
                            if (type.equals(StatList.field_199092_j)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.custom", (Object[])new Object[0]);
                            }
                            if (type.equals(StatList.field_199090_h)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.killed", (Object[])new Object[0]);
                            }
                            if (type.equals(StatList.field_199091_i)) {
                                return I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.stat.killed_by", (Object[])new Object[0]);
                            }
                            return I18n.func_135052_a((String)type.func_199078_c(), (Object[])new Object[0]);
                        }
                        String translation = RegistryTranslator.translate(resource);
                        if (translation != null) {
                            return I18n.func_135052_a((String)translation, (Object[])new Object[0]);
                        }
                    }
                    if (Arrays.stream(EnumColor.values()).map(EnumColor::getFormat).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                        return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.objectives.stat." + key), (Object[])new Object[0]);
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboardObjectives.this.builderObjectives.setCriteria(key);
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    if (this.isRegistryItem(keys.get(keys.size() - 1))) {
                        return String.join((CharSequence)":", keys);
                    }
                    return ILogicClickList.super.buildEventKey(keys, depth);
                }

                @Override
                public String getId() {
                    return "objectives";
                }

                @Nullable
                private ResourceLocation makeResourceLocation(String key) {
                    return ResourceLocation.func_208304_a((String)key.replace(".", ":"));
                }

                @Nullable
                private boolean isRegistryItem(String key) {
                    return this.isRegistryItem(this.makeResourceLocation(key));
                }

                @Nullable
                private boolean isRegistryItem(ResourceLocation resource) {
                    IForgeRegistry[] registries;
                    for (IForgeRegistry registry : registries = new IForgeRegistry[]{ForgeRegistries.BLOCKS, ForgeRegistries.ITEMS, ForgeRegistries.ENTITIES}) {
                        if (!registry.containsKey(resource)) continue;
                        return true;
                    }
                    return IRegistry.field_212623_l.func_212607_c(resource);
                }
            });
            container.add(objectives);
        } else if (this.selectedObjective.equals("display") || this.selectedObjective.equals("undisplay")) {
            ElementMultiButtonList slots = new ElementMultiButtonList(x + 118, y + 24 + (this.selectedObjective.equals("undisplay") ? -12 : 0), HELPER.getSlots(), 2, new ILogicClickList(){

                @Override
                public String translate(String key, int depth) {
                    if (depth == 0) {
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.slot." + key), (Object[])new Object[0]);
                    }
                    if (depth == 1) {
                        return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                    }
                    return key;
                }

                @Override
                public void onClick(String key, int depth) {
                    ContentScoreboardObjectives.this.builderObjectives.setSlot(key);
                }

                @Override
                public String getId() {
                    return "slots";
                }
            });
            container.add(slots);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        int yOffset;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.create", (Object[])new Object[0]), () -> {
            this.selectedObjective = "create";
            container.func_73866_w_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.display", (Object[])new Object[0]), () -> {
            this.selectedObjective = "display";
            container.func_73866_w_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.undisplay", (Object[])new Object[0]), () -> {
            this.selectedObjective = "undisplay";
            container.func_73866_w_();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.remove", (Object[])new Object[0]), () -> {
            this.selectedObjective = "remove";
            container.func_73866_w_();
        });
        container.add(button4);
        button1.field_146124_l = !this.selectedObjective.equals("create");
        button2.field_146124_l = !this.selectedObjective.equals("display");
        button3.field_146124_l = !this.selectedObjective.equals("undisplay");
        boolean bl = button4.field_146124_l = !this.selectedObjective.equals("remove");
        int n = this.selectedObjective.equals("undisplay") ? -12 : (yOffset = this.selectedObjective.equals("remove") ? -24 : 0);
        if (this.selectedObjective.equals("undisplay")) {
            this.builderObjectives.setObjective(null);
        } else if (this.selectedObjective.equals("remove")) {
            this.builderObjectives.setMode(BuilderScoreboardObjectives.EnumMode.REMOVE);
        }
        if (!this.selectedObjective.equals("undisplay")) {
            container.add(this.objectField);
            this.builderObjectives.setObjective(ContentScoreboard.getObjective());
        }
        button1 = new GuiButtonBase(x + 118, y + 72 + yOffset, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]), () -> {
            CommandHelper.sendCommand(this.builderObjectives);
            container.func_73866_w_();
        });
        container.add(button1);
        button1.field_146124_l = this.selectedObjective.equals("undisplay") || ContentScoreboard.isObjectiveValid();
    }

    @Override
    public void tick(Container container) {
        if (!this.selectedObjective.equals("undisplay")) {
            this.objectField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.selectedObjective.equals("undisplay")) {
            this.objectField.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.objectives", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_OBJECTIVES;
    }
}

