/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderScoreboardPlayers;
import exopandora.worldhandler.builder.impl.BuilderTag;
import exopandora.worldhandler.builder.impl.BuilderTrigger;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.abstr.ContentScoreboard;
import exopandora.worldhandler.gui.logic.LogicSliderSimple;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardPlayers
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private GuiTextFieldTooltip tagField;
    private final BuilderScoreboardPlayers builderPlayers = new BuilderScoreboardPlayers();
    private final BuilderTag builderTag = new BuilderTag();
    private final BuilderTrigger builderTrigger = new BuilderTrigger();
    private final BuilderMultiCommand builderTriggerMulti = new BuilderMultiCommand(this.builderTrigger, this.builderPlayers);
    private String selectedPlayer = "add|set|remove";
    private String tag;
    private GuiButtonBase addButton;
    private GuiButtonBase removeButton;

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (this.selectedPlayer.equals("add|set|remove")) {
            return this.builderPlayers;
        }
        if (this.selectedPlayer.equals("tag")) {
            return this.builderTag;
        }
        if (this.selectedPlayer.equals("enable")) {
            return this.builderTriggerMulti;
        }
        return null;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPlayers.getPoints() > Config.getSliders().getMaxPlayerPoints()) {
            this.builderPlayers.setPoints((int)Config.getSliders().getMaxPlayerPoints());
        }
        if ((double)this.builderTrigger.getValue() > Config.getSliders().getMaxTriggerValue()) {
            this.builderTrigger.setValue((int)Config.getSliders().getMaxTriggerValue());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.func_200675_a((Predicate)Predicates.notNull());
        this.objectField.func_146180_a(ContentScoreboard.getObjective());
        this.objectField.func_195609_a((id, text) -> {
            ContentScoreboard.setObjective(text);
            this.builderPlayers.setObjective(ContentScoreboard.getObjective());
            this.builderTrigger.setObjective(ContentScoreboard.getObjective());
            container.initButtons();
        });
        this.tagField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]));
        this.tagField.func_200675_a(string -> string != null && !string.contains(" "));
        this.tagField.func_146180_a(this.tag);
        this.tagField.func_195609_a((id, text) -> {
            this.tag = text;
            this.builderTag.setName(this.tag);
            container.initButtons();
        });
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]), () -> {
            this.selectedPlayer = "add|set|remove";
            container.func_73866_w_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]), () -> {
            this.selectedPlayer = "tag";
            container.func_73866_w_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.trigger", (Object[])new Object[0]), () -> {
            this.selectedPlayer = "enable";
            container.func_73866_w_();
        });
        container.add(button3);
        button1.field_146124_l = !this.selectedPlayer.equals("add|set|remove");
        button2.field_146124_l = !this.selectedPlayer.equals("tag");
        button3.field_146124_l = !this.selectedPlayer.equals("enable");
        boolean enabled = ContentScoreboard.isObjectiveValid();
        this.builderPlayers.setMode(this.selectedPlayer);
        if (this.selectedPlayer.equals("add|set|remove")) {
            boolean points;
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxPlayerPoints(), 0.0, container, new LogicSliderSimple("points", I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]), value -> this.builderPlayers.setPoints((int)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.ADD));
                container.func_73866_w_();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.REMOVE));
                container.func_73866_w_();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonTooltip(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.set_to_0", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumMode.SET, 0));
                container.func_73866_w_();
            });
            container.add(button1);
            this.addButton.field_146124_l = points = enabled && this.builderPlayers.getPoints() > 0;
            this.removeButton.field_146124_l = points;
            button1.field_146124_l = enabled;
        } else if (this.selectedPlayer.equals("tag")) {
            boolean tag;
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTag.getBuilderForMode(BuilderTag.EnumMode.ADD));
                container.func_73866_w_();
            });
            container.add(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTag.getBuilderForMode(BuilderTag.EnumMode.REMOVE));
                container.func_73866_w_();
            });
            container.add(button2);
            button1.field_146124_l = tag = this.tag != null && !this.tag.isEmpty();
            button2.field_146124_l = tag;
        } else if (this.selectedPlayer.equals("enable")) {
            container.add(new GuiSlider(x + 118, y + 24, 114, 20, 0.0, Config.getSliders().getMaxTriggerValue(), 0.0, container, new LogicSliderSimple("enable", I18n.func_135052_a((String)"gui.worldhandler.generic.value", (Object[])new Object[0]), value -> this.builderTrigger.setValue((int)value))));
            this.addButton = new GuiButtonBase(x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTrigger.getBuilderForMode(BuilderTrigger.EnumMode.ADD));
                container.func_73866_w_();
            });
            container.add(this.addButton);
            this.removeButton = new GuiButtonBase(x + 118 + 57 + 1, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.set", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTrigger.getBuilderForMode(BuilderTrigger.EnumMode.SET));
                container.func_73866_w_();
            });
            container.add(this.removeButton);
            button1 = new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderPlayers.getBuilderForEnable());
                container.func_73866_w_();
            });
            container.add(button1);
            this.addButton.field_146124_l = enabled && this.builderTrigger.getValue() > 0;
            this.removeButton.field_146124_l = enabled;
            button1.field_146124_l = enabled;
        }
        if (this.selectedPlayer.equals("tag")) {
            container.add(this.tagField);
        } else {
            container.add(this.objectField);
            this.builderPlayers.setObjective(ContentScoreboard.getObjective());
            this.builderTrigger.setObjective(ContentScoreboard.getObjective());
        }
    }

    @Override
    public void tick(Container container) {
        if (this.selectedPlayer.equals("tag")) {
            this.tagField.func_146178_a();
        } else {
            boolean enabled = ContentScoreboard.isObjectiveValid();
            if (this.selectedPlayer.equals("add|set|remove")) {
                boolean points;
                this.addButton.field_146124_l = points = enabled && this.builderPlayers.getPoints() > 0;
                this.removeButton.field_146124_l = points;
            } else if (this.selectedPlayer.equals("enable")) {
                this.addButton.field_146124_l = enabled && this.builderTrigger.getValue() > 0;
                this.removeButton.field_146124_l = enabled;
            }
            this.objectField.func_146178_a();
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedPlayer.equals("tag")) {
            this.tagField.func_195608_a(mouseX, mouseY, partialTicks);
        } else {
            this.objectField.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.players", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_PLAYERS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPlayers.setPlayer(username);
        this.builderTag.setPlayer(username);
    }
}

