/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderTeams;
import exopandora.worldhandler.format.EnumColor;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementMultiButtonList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentScoreboard;
import exopandora.worldhandler.gui.logic.ILogicClickList;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.CommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentScoreboardTeams
extends ContentScoreboard {
    private GuiTextFieldTooltip teamField;
    private String team;
    private String selectedTeam = "add";
    private final BuilderTeams builderTeams = new BuilderTeams();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderTeams;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.teamField = new GuiTextFieldTooltip(x + 118, y + (this.selectedTeam.equals("option") ? 0 : (this.selectedTeam.equals("add") ? 24 : 12)), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.team", (Object[])new Object[0]));
        this.teamField.func_200675_a((Predicate)Predicates.notNull());
        this.teamField.func_146180_a(this.team);
        this.teamField.func_195609_a((id, text) -> {
            this.team = text;
            this.builderTeams.setTeam(this.team);
            container.initButtons();
        });
        if (this.selectedTeam.equals("option")) {
            ElementMultiButtonList options = new ElementMultiButtonList(x + 118, y + 24, HELPER.getOptions(), 2, new ILogicClickList(){

                @Override
                public String translate(String key, int depth) {
                    if (depth == 0) {
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.team.options." + key), (Object[])new Object[0]);
                    }
                    if (depth == 1) {
                        if (Arrays.stream(EnumColor.values()).map(EnumColor::getFormat).anyMatch((Predicate<String>)Predicates.equalTo((Object)key))) {
                            return I18n.func_135052_a((String)("gui.worldhandler.color." + key), (Object[])new Object[0]);
                        }
                        return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.team.suboption." + key), (Object[])new Object[0]);
                    }
                    return key;
                }

                @Override
                public String buildEventKey(List<String> keys, int depth) {
                    return ILogicClickList.super.buildTranslationKey(keys, depth);
                }

                @Override
                public void onClick(String key, int depth) {
                    if (depth == 0) {
                        ContentScoreboardTeams.this.builderTeams.setRule(key);
                    } else if (depth == 1) {
                        ContentScoreboardTeams.this.builderTeams.setValue(key);
                    }
                }

                @Override
                public String getId() {
                    return "options";
                }
            });
            container.add(options);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.create", (Object[])new Object[0]), () -> {
            this.selectedTeam = "add";
            container.func_73866_w_();
        });
        container.add(button1);
        GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.join", (Object[])new Object[0]) + " / " + I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.leave", (Object[])new Object[0]), () -> {
            this.selectedTeam = "join|leave";
            container.func_73866_w_();
        });
        container.add(button2);
        GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.remove", (Object[])new Object[0]) + " / " + I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.empty", (Object[])new Object[0]), () -> {
            this.selectedTeam = "remove|empty";
            container.func_73866_w_();
        });
        container.add(button3);
        GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.options", (Object[])new Object[0]), () -> {
            this.selectedTeam = "option";
            container.func_73866_w_();
        });
        container.add(button4);
        button1.field_146124_l = !this.selectedTeam.equals("add");
        button2.field_146124_l = !this.selectedTeam.equals("join|leave");
        button3.field_146124_l = !this.selectedTeam.equals("remove|empty");
        button4.field_146124_l = !this.selectedTeam.equals("option");
        this.builderTeams.setMode(this.selectedTeam);
        boolean bl = enabled = this.team != null && this.team.length() > 0;
        if (this.selectedTeam.equals("add")) {
            this.builderTeams.setTeam(this.team);
        } else if (this.selectedTeam.equals("join|leave")) {
            this.builderTeams.setPlayer(container.getPlayer());
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.join", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.JOIN));
                container.initButtons();
            });
            container.add(button1);
            container.add(new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.leave", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.LEAVE));
                container.initButtons();
            }));
            button1.field_146124_l = enabled;
        } else if (this.selectedTeam.equals("remove|empty")) {
            button1 = new GuiButtonBase(x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.remove", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.REMOVE));
                container.initButtons();
            });
            container.add(button1);
            button2 = new GuiButtonBase(x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.team.empty", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams.getBuilderForMode(BuilderTeams.EnumMode.EMPTY));
                container.initButtons();
            });
            container.add(button2);
            button1.field_146124_l = enabled;
            button2.field_146124_l = enabled;
        }
        if (!this.selectedTeam.equals("join|leave") && !this.selectedTeam.equals("remove|empty")) {
            int yOffset = this.selectedTeam.equals("option") ? 24 : 0;
            button1 = new GuiButtonBase(x + 118, y + 48 + yOffset, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]), () -> {
                CommandHelper.sendCommand(this.builderTeams);
                container.initButtons();
            });
            container.add(button1);
            button1.field_146124_l = enabled;
        }
        container.add(this.teamField);
    }

    @Override
    public void tick(Container container) {
        this.teamField.func_146178_a();
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.teamField.func_195608_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.teams", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_TEAMS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        if (this.selectedTeam.equals("join|leave")) {
            this.builderTeams.setPlayer(username);
        }
    }
}

