/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderSignEditor;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementColorMenu;
import exopandora.worldhandler.gui.logic.ILogicColorMenu;
import exopandora.worldhandler.helper.ActionHelper;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.helper.CommandHelper;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentSignEditor
extends Content {
    private int selectedLine = 0;
    private boolean editColor;
    private GuiTextFieldTooltip commandField;
    private final BuilderSignEditor builderSignEditor = new BuilderSignEditor();
    private boolean isActive;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.isActive ? this.builderSignEditor : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.isFocusedBlockEqualTo(Blocks.field_196649_cc) || BlockHelper.isFocusedBlockEqualTo(Blocks.field_150444_as);
        this.builderSignEditor.setPosition(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initGui(Container container, int x, int y) {
        if (this.isActive) {
            this.commandField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.commmand", (Object[])new Object[0]));
            this.commandField.func_200675_a((Predicate)Predicates.notNull());
            this.commandField.func_146180_a(this.builderSignEditor.getCommand(this.selectedLine));
            this.commandField.func_146202_e();
            this.commandField.func_195609_a((id, text) -> {
                this.builderSignEditor.setCommand(this.selectedLine, (String)text);
                container.initButtons();
            });
            ElementColorMenu colors = new ElementColorMenu(x, y, "gui.worldhandler.blocks.sign_editor.text_line_" + (this.selectedLine + 1), this.builderSignEditor.getColoredString(this.selectedLine), new ILogicColorMenu(){

                @Override
                public boolean validate(String text) {
                    return Minecraft.func_71410_x().field_71466_p.func_78256_a(text) <= 90;
                }

                @Override
                public boolean doDrawButtons() {
                    return ContentSignEditor.this.editColor;
                }

                @Override
                public String getId() {
                    return "color" + ContentSignEditor.this.selectedLine;
                }
            });
            container.add(colors);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0]), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0]), ActionHelper::backToGame));
        if (this.isActive) {
            GuiButtonBase button1 = new GuiButtonBase(x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_1", (Object[])new Object[0]), () -> {
                this.selectedLine = 0;
                container.func_73866_w_();
            });
            container.add(button1);
            GuiButtonBase button2 = new GuiButtonBase(x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_2", (Object[])new Object[0]), () -> {
                this.selectedLine = 1;
                container.func_73866_w_();
            });
            container.add(button2);
            GuiButtonBase button3 = new GuiButtonBase(x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_3", (Object[])new Object[0]), () -> {
                this.selectedLine = 2;
                container.func_73866_w_();
            });
            container.add(button3);
            GuiButtonBase button4 = new GuiButtonBase(x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_4", (Object[])new Object[0]), () -> {
                this.selectedLine = 3;
                container.func_73866_w_();
            });
            container.add(button4);
            if (this.editColor) {
                container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.done", (Object[])new Object[0]), () -> this.toggleEditColor(container)));
            } else {
                container.add(this.commandField);
                container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.format_text_line", (Object[])new Object[0]), () -> this.toggleEditColor(container)));
                container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), () -> CommandHelper.sendCommand(this.builderSignEditor, this.builderSignEditor.isSpecial())));
            }
            button1.field_146124_l = this.selectedLine != 0;
            button2.field_146124_l = this.selectedLine != 1;
            button3.field_146124_l = this.selectedLine != 2;
            button4.field_146124_l = this.selectedLine != 3;
        }
    }

    private void toggleEditColor(Container container) {
        this.editColor = !this.editColor;
        container.func_73866_w_();
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            if (!this.editColor) {
                this.commandField.func_195608_a(mouseX, mouseY, partialTicks);
            }
        } else {
            float scale = 4.0f;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)((float)(container.field_146294_l / 2) - 8.5f * scale), (float)((float)(container.field_146295_m / 2 - 15) - 8.5f * scale), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack((IItemProvider)Items.field_151155_ap), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            String displayString = I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.look_at_sign", (Object[])new Object[]{WorldHandler.KEY_WORLD_HANDLER.func_197978_k()});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_211126_b(displayString, (float)(x + 116 - fontRenderer.func_78256_a(displayString) / 2), (float)(y + 70), Config.getSkin().getLabelColor());
        }
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.blocks.sign_editor", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.blocks.sign_editor", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SIGN_EDITOR;
    }
}

