/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.helper;

import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.impl.BuilderDifficulty;
import exopandora.worldhandler.builder.impl.BuilderGamemode;
import exopandora.worldhandler.builder.impl.BuilderTime;
import exopandora.worldhandler.builder.impl.BuilderWeather;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandler;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.util.ActionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ActionHelper {
    public static void backToGame() {
        Minecraft.func_71410_x().func_147108_a(null);
        Minecraft.func_71410_x().field_71417_B.func_198034_i();
    }

    public static void back(Content content) throws Exception {
        if (content.getBackContent() != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(content.getBackContent()));
        }
    }

    public static void changeTab(Content content, int index) {
        ActionHelper.tryRun(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(content.getCategory().getContent(index))));
    }

    public static void timeDawn() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getDawn()));
    }

    public static void timeNoon() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getNoon()));
    }

    public static void timeSunset() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getSunset()));
    }

    public static void timeMidnight() {
        CommandHelper.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, Config.getSettings().getMidnight()));
    }

    public static void weatherClear() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.CLEAR));
    }

    public static void weatherRain() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.RAIN));
    }

    public static void weatherThunder() {
        CommandHelper.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.THUNDER));
    }

    public static void difficultyPeaceful() {
        CommandHelper.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.PEACEFUL));
    }

    public static void difficultyEasy() {
        CommandHelper.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.EASY));
    }

    public static void difficultyNormal() {
        CommandHelper.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.NORMAL));
    }

    public static void difficultyHard() {
        CommandHelper.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.HARD));
    }

    public static void gamemodeSurvival() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SURVIVAL));
    }

    public static void gamemodeCreative() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.CREATIVE));
    }

    public static void gamemodeAdventure() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.ADVENTURE));
    }

    public static void gamemodeSpectator() {
        CommandHelper.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SPECTATOR));
    }

    public static void tryRun(ActionHandler action) {
        try {
            action.run();
        }
        catch (Exception e) {
            if (!Minecraft.func_71410_x().func_195544_aj()) {
                Minecraft.func_71410_x().func_147108_a(null);
                Minecraft.func_71410_x().field_71417_B.func_198034_i();
            }
            TextComponentString name = new TextComponentString("World Handler");
            name.func_150255_a(new Style().func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/world-handler-command-gui")));
            TextComponentTranslation message = new TextComponentTranslation("worldhandler.error.gui", new Object[]{name});
            message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)message);
            WorldHandler.LOGGER.throwing((Throwable)e);
        }
    }

    public static void displayGui() {
        if (!CommandHelper.canPlayerIssueCommand() && Config.getSettings().permissionQuery()) {
            Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused", (Object[])new Object[0])));
            Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused.change", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.config.key.settings.permission_query", (Object[])new Object[0])})));
        } else {
            ActionHelper.tryRun(() -> {
                if (BlockHelper.isFocusedBlockEqualTo(Blocks.field_196649_cc) || BlockHelper.isFocusedBlockEqualTo(Blocks.field_150444_as)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.SIGN_EDITOR));
                } else if (BlockHelper.isFocusedBlockEqualTo(Blocks.field_196586_al)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.NOTE_EDITOR));
                } else {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandler(Contents.MAIN));
                }
            });
        }
    }
}

