/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.helper;

import exopandora.worldhandler.builder.impl.BuilderFill;
import exopandora.worldhandler.builder.impl.BuilderSetBlock;
import exopandora.worldhandler.builder.impl.BuilderSummon;
import exopandora.worldhandler.builder.types.BlockResourceLocation;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.CoordinateDouble;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.helper.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUpdateCommandBlock;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class BlockHelper {
    private static BlockPos POS_1 = BlockPos.field_177992_a;
    private static BlockPos POS_2 = BlockPos.field_177992_a;
    private static final List<Consumer<BlockPos>> POS_1_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final List<Consumer<BlockPos>> POS_2_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final Block[] BLACKLIST = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150353_l};

    public static BlockPos getFocusedBlockPos() {
        BlockPos position;
        RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
        if (rayTrace != null && rayTrace.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK) && !ArrayUtils.contains((Object[])BLACKLIST, (Object)Minecraft.func_71410_x().field_71441_e.func_180495_p(position = rayTrace.func_178782_a()).func_177230_c())) {
            return position;
        }
        return Minecraft.func_71410_x().field_71439_g.func_180425_c();
    }

    public static boolean isFocusedBlockEqualTo(Block block) {
        return BlockHelper.getBlock(BlockHelper.getFocusedBlockPos()) == block;
    }

    public static Block getBlock(BlockPos pos) {
        return Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c();
    }

    public static BlockPos setX(BlockPos pos, double x) {
        return new BlockPos(x, (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static BlockPos setY(BlockPos pos, double y) {
        return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
    }

    public static BlockPos setZ(BlockPos pos, double z) {
        return new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o(), z);
    }

    @Nonnull
    public static BlockPos getPos1() {
        return POS_1;
    }

    public static void setPos1(BlockPos pos1) {
        if (POS_1 != null && !POS_1.equals((Object)pos1)) {
            POS_1 = pos1;
            for (Consumer<BlockPos> observer : POS_1_OBSERVERS) {
                observer.accept(POS_1);
            }
        }
    }

    @Nonnull
    public static BlockPos getPos2() {
        return POS_2;
    }

    public static void setPos2(BlockPos pos2) {
        if (POS_2 != null && !POS_2.equals((Object)pos2)) {
            POS_2 = pos2;
            for (Consumer<BlockPos> observer : POS_2_OBSERVERS) {
                observer.accept(POS_2);
            }
        }
    }

    public static <T> T addPositionObservers(T observer, Function<T, Consumer<BlockPos>> pos1generator, Function<T, Consumer<BlockPos>> pos2generator) {
        BlockHelper.addPos1Observer(pos1generator.apply(observer));
        BlockHelper.addPos2Observer(pos2generator.apply(observer));
        return observer;
    }

    public static void addPos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.add(observer);
    }

    public static void removePos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.remove(observer);
    }

    public static void addPos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    public static void removePos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    private static NBTTagCompound newCommandBlock(String command) {
        NBTTagCompound blockState = new NBTTagCompound();
        blockState.func_74778_a("Name", Blocks.field_150483_bI.getRegistryName().toString());
        NBTTagCompound tileEntityData = new NBTTagCompound();
        tileEntityData.func_74778_a("Command", command);
        tileEntityData.func_74757_a("auto", true);
        NBTTagCompound commandBlock = new NBTTagCompound();
        commandBlock.func_74768_a("Time", 1);
        commandBlock.func_74782_a("BlockState", (INBTBase)blockState);
        commandBlock.func_74782_a("TileEntityData", (INBTBase)tileEntityData);
        return commandBlock;
    }

    public static boolean setCommandBlockNearPlayer(String command) {
        if (CommandHelper.canPlayerIssueCommand() && Minecraft.func_71410_x().func_147114_u() != null) {
            BuilderFill fill = new BuilderFill();
            fill.setX1(new CoordinateInt(0, Coordinate.CoordinateType.GLOBAL));
            fill.setY1(new CoordinateInt(-2, Coordinate.CoordinateType.GLOBAL));
            fill.setZ1(new CoordinateInt(0, Coordinate.CoordinateType.GLOBAL));
            fill.setX2(new CoordinateInt(0, Coordinate.CoordinateType.GLOBAL));
            fill.setY2(new CoordinateInt(0, Coordinate.CoordinateType.GLOBAL));
            fill.setZ2(new CoordinateInt(0, Coordinate.CoordinateType.GLOBAL));
            fill.setBlock1(new BlockResourceLocation(Blocks.field_150350_a.getRegistryName()));
            NBTTagCompound block = BlockHelper.newCommandBlock(fill.toActualCommand());
            block.func_74778_a("id", "falling_block");
            NBTTagList passengers = new NBTTagList();
            passengers.add((INBTBase)block);
            NBTTagCompound nbt = BlockHelper.newCommandBlock(command);
            nbt.func_74782_a("Passengers", (INBTBase)passengers);
            Minecraft.func_71410_x().func_147108_a(null);
            Minecraft.func_71410_x().field_71417_B.func_198034_i();
            BuilderSummon summon = new BuilderSummon();
            summon.setEntity(EntityType.field_200809_w.getRegistryName().toString());
            summon.setX(new CoordinateDouble(0.0, Coordinate.CoordinateType.LOCAL));
            summon.setY(new CoordinateDouble(0.54, Coordinate.CoordinateType.LOCAL));
            summon.setZ(new CoordinateDouble(0.0, Coordinate.CoordinateType.LOCAL));
            summon.setNBT(nbt);
            BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177982_a(0, 3, 0);
            Minecraft.func_71410_x().field_71439_g.func_71165_d(new BuilderSetBlock(pos, Blocks.field_150483_bI.getRegistryName(), Config.CLIENT.getSettings().getBlockPlacingMode()).toActualCommand());
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketUpdateCommandBlock(pos, summon.toActualCommand(false), TileEntityCommandBlock.Mode.REDSTONE, true, false, true));
            return true;
        }
        return false;
    }

    public static void setBlockNearPlayer(Block block) {
        System.out.println(Minecraft.func_71410_x().field_71439_g.func_174811_aO());
        switch (Minecraft.func_71410_x().field_71439_g.func_174811_aO()) {
            case NORTH: {
                CommandHelper.sendCommand(new BuilderSetBlock(new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(2, Coordinate.CoordinateType.LOCAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode()).withState(BlockStateProperties.field_208157_J, EnumFacing.SOUTH));
                break;
            }
            case EAST: {
                CommandHelper.sendCommand(new BuilderSetBlock(new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(2, Coordinate.CoordinateType.LOCAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode()).withState(BlockStateProperties.field_208157_J, EnumFacing.WEST));
                break;
            }
            case SOUTH: {
                CommandHelper.sendCommand(new BuilderSetBlock(new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(2, Coordinate.CoordinateType.LOCAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode()).withState(BlockStateProperties.field_208157_J, EnumFacing.NORTH));
                break;
            }
            case WEST: {
                CommandHelper.sendCommand(new BuilderSetBlock(new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(Coordinate.CoordinateType.LOCAL), new CoordinateInt(2, Coordinate.CoordinateType.LOCAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode()).withState(BlockStateProperties.field_208157_J, EnumFacing.EAST));
                break;
            }
        }
    }
}

