/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class RegistryTranslator {
    private static final Map<IForgeRegistry<?>, Function<?, String>> FORGE = new HashMap();
    private static final Map<IRegistry<?>, Function<?, String>> VANILLA = new HashMap();

    private static <T extends ForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, Function<T, String> mapper) {
        FORGE.put(registry, mapper);
    }

    private static <T> void register(IRegistry<T> registry, Function<T, String> mapper) {
        VANILLA.put(registry, mapper);
    }

    @Nullable
    public static <T> String translate(ResourceLocation resource) {
        for (IForgeRegistry<?> iForgeRegistry : FORGE.keySet()) {
            if (!iForgeRegistry.containsKey(resource)) continue;
            return FORGE.get(iForgeRegistry).apply(iForgeRegistry.getValue(resource));
        }
        for (IRegistry iRegistry : VANILLA.keySet()) {
            if (!iRegistry.func_212607_c(resource)) continue;
            return VANILLA.get(iRegistry).apply(iRegistry.func_212608_b(resource));
        }
        return null;
    }

    static {
        RegistryTranslator.register(ForgeRegistries.BLOCKS, Block::func_149739_a);
        RegistryTranslator.register(ForgeRegistries.ITEMS, Item::func_77658_a);
        RegistryTranslator.register(ForgeRegistries.POTIONS, Potion::func_76393_a);
        RegistryTranslator.register(ForgeRegistries.BIOMES, Biome::func_210773_k);
        RegistryTranslator.register(ForgeRegistries.ENCHANTMENTS, Enchantment::func_77320_a);
        RegistryTranslator.register(ForgeRegistries.ENTITIES, EntityType::func_210760_d);
        RegistryTranslator.register(IRegistry.field_212623_l, (T stat) -> "stat." + stat.toString().replace(':', '.'));
    }
}

