/*
 * Decompiled with CFR 0.152.
 */
package com.xray.common.config;

import com.xray.common.XRay;
import com.xray.common.reference.OreInfo;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    private static Configuration config = null;
    private static Minecraft mc = Minecraft.func_71410_x();

    public static void setup(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        XRay.currentDist = config.get("general", "searchdist", 0).getInt();
        for (String category : config.getCategoryNames()) {
            ConfigCategory cat = config.getCategory(category);
            if (!category.startsWith("ores.")) continue;
            String name = cat.get("name").getString();
            int id = cat.get("id").getInt();
            int meta = cat.get("meta").getInt();
            int[] color = new int[]{cat.get("red").getInt(), cat.get("green").getInt(), cat.get("blue").getInt()};
            boolean enabled = cat.get("enabled").getBoolean(false);
            XRay.searchList.add(new OreInfo(name, name.replaceAll("\\s+", ""), id, meta, color, enabled));
        }
        config.save();
    }

    public static void add(String oreName, Integer id, Integer meta, int[] color) {
        config.load();
        String cleanName = oreName.replaceAll("\\s+", "").toLowerCase();
        for (String ignored : config.getCategoryNames()) {
            if (!Objects.equals(config.get("ores." + cleanName, "name", "").getString(), cleanName)) continue;
            String notify = String.format("[XRay] %s already exists. Please enter a different name. ", oreName);
            ConfigHandler.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
            return;
        }
        for (String category : config.getCategoryNames()) {
            if (!category.startsWith("ores.")) continue;
            config.get("ores." + cleanName, "name", "").set(oreName);
            config.get("ores." + cleanName, "enabled", "false").set(true);
            config.get("ores." + cleanName, "id", "").set(id.intValue());
            config.get("ores." + cleanName, "meta", "").set(meta.intValue());
            config.get("ores." + cleanName, "red", "").set(color[0]);
            config.get("ores." + cleanName, "green", "").set(color[1]);
            config.get("ores." + cleanName, "blue", "").set(color[2]);
        }
        config.save();
    }

    public static void update(String string, boolean draw) {
        if (string.equals("searchdist")) {
            config.get("general", "searchdist", 0).set(XRay.currentDist);
            config.save();
            return;
        }
        for (String category : config.getCategoryNames()) {
            String cleanStr = string.replaceAll("\\s+", "").toLowerCase();
            String[] splitCat = category.split("\\.");
            if (splitCat.length != 2 || !splitCat[0].equals("ores") || !splitCat[1].equals(cleanStr)) continue;
            config.get("ores." + cleanStr, "enabled", false).set(draw);
        }
        config.save();
    }

    public static void updateInfo(OreInfo original, OreInfo newInfo) {
        for (String category : config.getCategoryNames()) {
            String cleanStr = original.getOreName().toLowerCase();
            String[] splitCat = category.split("\\.");
            if (splitCat.length != 2 || !splitCat[1].equals(cleanStr)) continue;
            String tmpCategory = "ores." + cleanStr;
            config.get(tmpCategory, "red", "").set(newInfo.color[0]);
            config.get(tmpCategory, "green", "").set(newInfo.color[1]);
            config.get(tmpCategory, "blue", "").set(newInfo.color[2]);
            config.get(tmpCategory, "name", "").set(newInfo.displayName);
            break;
        }
        config.save();
    }

    public static void remove(OreInfo original) {
        for (String category : config.getCategoryNames()) {
            String cleanStr = original.getOreName().toLowerCase();
            String[] splitCat = category.split("\\.");
            if (splitCat.length != 2 || !splitCat[1].equals(cleanStr)) continue;
            config.removeCategory(config.getCategory("ores." + cleanStr));
            break;
        }
        config.save();
    }
}

