/*
 * Decompiled with CFR 0.152.
 */
package com.xray.common.config;

import com.xray.common.reference.OreInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class DefaultConfig {
    private static final Map<String, OreInfo> defaults = new HashMap<String, OreInfo>(){
        {
            this.put("oreLapis", new OreInfo("lapis", new int[]{0, 0, 255}, false));
            this.put("oreCopper", new OreInfo("copper", new int[]{204, 102, 0}, true));
            this.put("oreTin", new OreInfo("tin", new int[]{161, 161, 161}, true));
            this.put("oreCobalt", new OreInfo("cobalt", new int[]{0, 0, 255}, false));
            this.put("oreArdite", new OreInfo("ardite", new int[]{255, 153, 0}, false));
            this.put("oreCertusQuartz", new OreInfo("certusquartz", new int[]{255, 255, 255}, false));
            this.put("oreUranium", new OreInfo("uranium", new int[]{0, 255, 0}, true));
            this.put("oreDiamond", new OreInfo("diamond", new int[]{136, 136, 255}, false));
            this.put("oreEmerald", new OreInfo("emerald", new int[]{0, 136, 10}, true));
            this.put("oreGold", new OreInfo("gold", new int[]{255, 255, 0}, false));
            this.put("oreRedstone", new OreInfo("redstone", new int[]{255, 0, 0}, false));
            this.put("oreIron", new OreInfo("iron", new int[]{170, 117, 37}, false));
            this.put("oreSilver", new OreInfo("silver", new int[]{143, 143, 143}, false));
            this.put("oreQuartz", new OreInfo("quartz", new int[]{30, 74, 0}, false));
            this.put("oreCoal", new OreInfo("coal", new int[]{0, 0, 0}, false));
        }
    };

    public static void create(Configuration config) {
        config.get("general", "searchdist", 0);
        for (Map.Entry<String, OreInfo> ore : defaults.entrySet()) {
            List listStack;
            String key = ore.getKey();
            OreInfo value = ore.getValue();
            if (!OreDictionary.doesOreNameExist((String)key) || (listStack = OreDictionary.getOres((String)key)).size() > 1 || listStack.isEmpty()) continue;
            ItemStack stack = (ItemStack)listStack.get(0);
            Block tmpBlock = Block.func_149634_a((Item)stack.func_77973_b());
            String category = value.oreName;
            config.get("ores." + category, "name", "").set(stack.func_82833_r());
            config.get("ores." + category, "id", -1).set(Block.func_149682_b((Block)tmpBlock));
            config.get("ores." + category, "meta", -1).set(stack.func_77960_j());
            config.get("ores." + category, "red", -1).set(value.color[0]);
            config.get("ores." + category, "green", -1).set(value.color[1]);
            config.get("ores." + category, "blue", -1).set(value.color[2]);
            config.get("ores." + category, "enabled", false).set(value.draw);
        }
    }
}

