/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemModifiedBucket
extends ItemBucket {
    private Block containedBlock;

    public ItemModifiedBucket(Block containedBlock) {
        super(containedBlock);
        this.containedBlock = containedBlock;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        BlockPos offsetPos;
        boolean isAir = this.containedBlock == Blocks.field_150350_a;
        RayTraceResult rayTrace = this.func_77621_a(world, player, isAir);
        ActionResult eventResul = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)rayTrace);
        if (eventResul != null) {
            return eventResul;
        }
        if (rayTrace == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = rayTrace.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (isAir) {
            if (!player.func_175151_a(pos.func_177972_a(rayTrace.field_178784_b), rayTrace.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBlockState state = world.func_180495_p(pos);
            Material material = state.func_185904_a();
            if (material == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(stack, player, SCContent.fWaterBucket));
            }
            if (material == Material.field_151587_i && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                player.func_184185_a(SoundEvents.field_187633_N, 1.0f, 1.0f);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(stack, player, SCContent.fLavaBucket));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        boolean isReplaceable = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
        BlockPos blockPos = offsetPos = isReplaceable && rayTrace.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(rayTrace.field_178784_b);
        if (!player.func_175151_a(offsetPos, rayTrace.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.func_180616_a(player, world, offsetPos)) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151133_ar)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        if (--emptyBuckets.field_77994_a <= 0) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket, 1, 0), false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(World world, BlockPos pos) {
        boolean isNotSolid;
        if (this.containedBlock == Blocks.field_150350_a) {
            return false;
        }
        Material material = world.func_180495_p(pos).func_185904_a();
        boolean bl = isNotSolid = !material.func_76220_a();
        if (!world.func_175623_d(pos) && !isNotSolid) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && this.containedBlock == Blocks.field_150358_i) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (EntityPlayer player : world.field_73010_i) {
                world.func_184133_a(player, new BlockPos((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f)), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("random.fizz")), SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            }
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && isNotSolid && !material.func_76224_d()) {
                world.func_175655_b(pos, true);
            }
            world.func_180501_a(pos, this.containedBlock.func_176223_P(), 3);
        }
        return true;
    }
}

