/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityKeypadFurnace
extends TileEntityOwnable
implements ISidedInventory,
IPasswordProtected {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    public ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    private String furnaceCustomName;
    private String passcode;

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.furnaceItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.furnaceItemStacks[index] != null) {
            if (this.furnaceItemStacks[index].field_77994_a <= count) {
                ItemStack itemstack = this.furnaceItemStacks[index];
                this.furnaceItemStacks[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[index].func_77979_a(count);
            if (this.furnaceItemStacks[index].field_77994_a == 0) {
                this.furnaceItemStacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.furnaceItemStacks[index] != null) {
            ItemStack stack = this.furnaceItemStacks[index];
            this.furnaceItemStacks[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean stacksEqual = stack != null && stack.func_77969_a(this.furnaceItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.furnaceItemStacks[index]);
        this.furnaceItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !stacksEqual) {
            this.totalCookTime = this.getTotalCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.furnace";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    public void setCustomInventoryName(String name) {
        this.furnaceCustomName = name;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.totalCookTime = tag.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityKeypadFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
        this.passcode = tag.func_74779_i("passcode");
        if (tag.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = tag.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
        tag.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return tag;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scaleFactor) {
        return this.cookTime * scaleFactor / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scaleFactor) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scaleFactor / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    @Override
    public void func_73660_a() {
        boolean isBurning = this.isBurning();
        boolean shouldMarkDirty = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!(this.isBurning() || this.furnaceItemStacks[1] != null && this.furnaceItemStacks[0] != null)) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityKeypadFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
                    if (this.isBurning()) {
                        shouldMarkDirty = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].field_77994_a;
                            if (this.furnaceItemStacks[1].field_77994_a == 0) {
                                this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItem(this.furnaceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getTotalCookTime(this.furnaceItemStacks[0]);
                        this.smeltItem();
                        shouldMarkDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (isBurning != this.isBurning()) {
                shouldMarkDirty = true;
            }
        }
        if (shouldMarkDirty) {
            this.func_70296_d();
        }
    }

    public int getTotalCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (stack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(stack)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + stack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = smeltResult.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77973_b() == smeltResult.func_77973_b()) {
                this.furnaceItemStacks[2].field_77994_a += smeltResult.field_77994_a;
            }
            if (this.furnaceItemStacks[0].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && this.furnaceItemStacks[0].func_77960_j() == 1 && this.furnaceItemStacks[1] != null && this.furnaceItemStacks[1].func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks[1] = new ItemStack(Items.field_151131_as);
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o(block.func_176223_P()) == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityKeypadFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntityKeypadFurnace.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String getGuiID() {
        return "minecraft:furnace";
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            this.furnaceItemStacks[i] = null;
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v()) instanceof BlockKeypadFurnace) {
            BlockKeypadFurnace.activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.getPassword() != null) {
            player.openGui((Object)SecurityCraft.instance, 10, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else if (this.getOwner().isOwner(player)) {
            player.openGui((Object)SecurityCraft.instance, 9, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        if (!isCodebreakerDisabled) {
            this.activate(player);
            return true;
        }
        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:keypadFurnace.name", new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }
}

