/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockCageTrap;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.PortalSize;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SCWorldListener;
import net.geforcemods.securitycraft.network.packets.PacketCPlaySoundAtPos;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SCEventHandler {
    public static HashMap<String, String> tipsWithLink = new HashMap();

    public SCEventHandler() {
        tipsWithLink.put("trello", "https://trello.com/b/dbCNZwx0/securitycraft");
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ConfigHandler.sayThanksMessage || !event.player.func_130014_f_().field_72995_K) {
            return;
        }
        String tipKey = this.getRandomTip();
        Object message = tipsWithLink.containsKey(tipKey.split("\\.")[2]) ? new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] " + ClientUtils.localize("messages.securitycraft:thanks", new Object[0]).replace("#", SecurityCraft.getVersion()) + " " + ClientUtils.localize("messages.securitycraft:tip", new Object[0]) + " " + ClientUtils.localize(tipKey, new Object[0]) + " ").func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2]))) : new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] " + ClientUtils.localize("messages.securitycraft:thanks", new Object[0]).replace("#", SecurityCraft.getVersion()) + " " + ClientUtils.localize("messages.securitycraft:tip", new Object[0]) + " " + ClientUtils.localize(tipKey, new Object[0]));
        event.player.func_145747_a((ITextComponent)message);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.player) && event.player.func_184187_bx() instanceof EntitySecurityCamera) {
            event.player.func_184187_bx().func_70106_y();
        }
    }

    @SubscribeEvent
    public void onDamageTaken(LivingHurtEvent event) {
        if (event.getEntityLiving() != null && PlayerUtils.isPlayerMountedOnCamera(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == CustomDamageSources.electricity) {
            SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, SCSounds.ELECTRIFIED.path, 0.25, "block"));
        }
    }

    @SubscribeEvent
    public void onBucketUsed(FillBucketEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        ItemStack result = this.fillBucket(event.getWorld(), event.getTarget().func_178782_a());
        if (result.func_190926_b()) {
            return;
        }
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == EnumHand.MAIN_HAND) {
            List sentries;
            World world = event.getWorld();
            if (!world.field_72995_K) {
                TileEntity tileEntity = world.func_175625_s(event.getPos());
                Block block = world.func_180495_p(event.getPos()).func_177230_c();
                if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.codebreaker) && this.handleCodebreaking((PlayerInteractEvent)event)) {
                    event.setCanceled(true);
                    return;
                }
                if (tileEntity != null && tileEntity instanceof CustomizableSCTE && PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.universalBlockModifier)) {
                    event.setCanceled(true);
                    if (!((IOwnable)tileEntity).getOwner().isOwner(event.getEntityPlayer())) {
                        PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), ClientUtils.localize("item.securitycraft:universalBlockModifier.name", new Object[0]), ClientUtils.localize("messages.securitycraft:notOwned", new Object[0]).replace("#", ((IOwnable)tileEntity).getOwner().getName()), TextFormatting.RED);
                        return;
                    }
                    event.getEntityPlayer().openGui((Object)SecurityCraft.instance, 100, world, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
                    return;
                }
                if (tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.getEntityPlayer(), Items.field_151057_cb) && event.getEntityPlayer().field_71071_by.func_70448_g().func_82837_s()) {
                    event.setCanceled(true);
                    for (String character : new String[]{"(", ")"}) {
                        if (!event.getEntityPlayer().field_71071_by.func_70448_g().func_82833_r().contains(character)) continue;
                        PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), "Naming", ClientUtils.localize("messages.securitycraft:naming.error", new Object[0]).replace("#n", event.getEntityPlayer().field_71071_by.func_70448_g().func_82833_r()).replace("#c", character), TextFormatting.RED);
                        return;
                    }
                    if (((INameable)tileEntity).getCustomName().equals(event.getEntityPlayer().field_71071_by.func_70448_g().func_82833_r())) {
                        PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), "Naming", ClientUtils.localize("messages.securitycraft:naming.alreadyMatches", new Object[0]).replace("#n", ((INameable)tileEntity).getCustomName()), TextFormatting.RED);
                        return;
                    }
                    if (!event.getEntityPlayer().func_184812_l_()) {
                        event.getEntityPlayer().field_71071_by.func_70448_g().func_190918_g(1);
                    }
                    ((INameable)tileEntity).setCustomName(event.getEntityPlayer().field_71071_by.func_70448_g().func_82833_r());
                    return;
                }
                if (tileEntity != null && this.isOwnableBlock(block, tileEntity) && PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.universalBlockRemover)) {
                    event.setCanceled(true);
                    if (!((IOwnable)tileEntity).getOwner().isOwner(event.getEntityPlayer())) {
                        PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), ClientUtils.localize("item.securitycraft:universalBlockRemover.name", new Object[0]), ClientUtils.localize("messages.securitycraft:notOwned", new Object[0]).replace("#", ((IOwnable)tileEntity).getOwner().getName()), TextFormatting.RED);
                        return;
                    }
                    if (block == SCContent.laserBlock) {
                        world.func_175655_b(event.getPos(), true);
                        BlockLaserBlock.destroyAdjacentLasers(event.getWorld(), event.getPos());
                        event.getEntityPlayer().field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                    } else if (block == SCContent.cageTrap && ((Boolean)world.func_180495_p(event.getPos()).func_177229_b((IProperty)BlockCageTrap.DEACTIVATED)).booleanValue()) {
                        BlockPos originalPos = event.getPos();
                        BlockPos pos = originalPos.func_177974_f().func_177984_a();
                        if (BlockUtils.getBlock(world, pos) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(2)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(3)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177984_a().func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(2).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(3).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177984_a()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(2)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(3)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177984_a().func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(2).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(3).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177984_a().func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(2).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(3).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177984_a()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(2)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(3)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177984_a().func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(2).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(3).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177984_a().func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(2).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(3).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177984_a().func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(2).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(3).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(4).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(4).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(4).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(4).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(4).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177974_f().func_177981_b(4)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177976_e().func_177981_b(4)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(4).func_177968_d()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(4).func_177978_c()) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        if (BlockUtils.getBlock(world, pos = originalPos.func_177981_b(4)) == SCContent.reinforcedIronBars && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(event.getEntityPlayer())) {
                            BlockUtils.destroyBlock(world, pos, false);
                        }
                        BlockUtils.destroyBlock(world, originalPos, false);
                    } else {
                        world.func_175655_b(event.getPos(), true);
                        world.func_175713_t(event.getPos());
                        event.getEntityPlayer().field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                    }
                    return;
                }
            }
            if (!(sentries = world.func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
                event.setCanceled(((EntitySentry)((Object)sentries.get(0))).func_184645_a(event.getEntityPlayer(), event.getHand()));
            }
        }
    }

    @SubscribeEvent
    public void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries = event.getWorld().func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()));
        if (!sentries.isEmpty()) {
            event.setCanceled(true);
            return;
        }
        sentries = event.getWorld().func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos().func_177984_a()));
        if (!sentries.isEmpty()) {
            ((EntitySentry)((Object)sentries.get(0))).remove();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("securitycraft")) {
            ConfigManager.sync((String)"securitycraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        this.handleOwnableTEs(event);
        if (event.getState().func_177230_c() == Blocks.field_150480_ab && event.getWorld().func_180495_p(event.getPos().func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian) {
            PortalSize portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
            if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                portalSize.placePortalBlocks();
            } else {
                portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z);
                if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                    portalSize.placePortalBlocks();
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getEntity().func_180425_c();
            do {
                Object portalSize;
                if (event.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.X);
                    if (portalSize.func_150860_b()) {
                        double y = (double)pos.func_177956_o() + 0.5;
                        if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                            y -= 3.0;
                        }
                        event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                        break;
                    }
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.Z);
                    if (!portalSize.func_150860_b()) continue;
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                if (event.getWorld().func_180495_p(pos).func_177230_c() != SCContent.reinforcedObsidian) continue;
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.X);
                if (((PortalSize)portalSize).isValid()) {
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.Z);
                if (!((PortalSize)portalSize).isValid()) continue;
                double y = (double)pos.func_177956_o() + 0.5;
                if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                    y -= 3.0;
                }
                event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                break;
            } while ((pos = pos.func_177984_a()).func_177956_o() < event.getWorld().func_72800_K());
        }
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150427_aO) {
            PortalSize portalSize;
            EnumFacing.Axis axis = (EnumFacing.Axis)event.getState().func_177229_b((IProperty)BlockPortal.field_176550_a);
            if (axis == EnumFacing.Axis.X) {
                PortalSize portalSize2 = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
                if (portalSize2.isValid() || portalSize2.getPortalBlockCount() > portalSize2.getWidth() * portalSize2.getHeight()) {
                    event.setCanceled(true);
                }
            } else if (axis == EnumFacing.Axis.Z && ((portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z)).isValid() || portalSize.getPortalBlockCount() > portalSize.getWidth() * portalSize.getHeight())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld().func_175625_s(event.getPos()) != null && event.getWorld().func_175625_s(event.getPos()) instanceof CustomizableSCTE) {
            CustomizableSCTE te = (CustomizableSCTE)event.getWorld().func_175625_s(event.getPos());
            for (int i = 0; i < te.getNumberOfCustomizableOptions(); ++i) {
                if (((ItemStack)te.modules.get(i)).func_190926_b()) continue;
                ItemStack stack = (ItemStack)te.modules.get(i);
                EntityItem item = new EntityItem(event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
                WorldUtils.addScheduledTask(event.getWorld(), () -> event.getWorld().func_72838_d((Entity)item));
                te.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
                te.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, te);
                if (!(te instanceof TileEntitySecurityCamera)) continue;
                te.func_145831_w().func_175685_c(te.func_174877_v().func_177967_a((EnumFacing)te.func_145831_w().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c(), true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getTarget() != event.getEntityLiving().func_94060_bK()) {
            if (PlayerUtils.isPlayerMountedOnCamera(event.getTarget())) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        } else if (event.getTarget() instanceof EntitySentry && event.getEntityLiving() instanceof EntityLiving) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new SCWorldListener());
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Item held;
        if (event.getEntityPlayer() != null && ((held = event.getEntityPlayer().func_184614_ca().func_77973_b()) == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3)) {
            for (Block rb : IReinforcedBlock.BLOCKS) {
                IReinforcedBlock reinforcedBlock = (IReinforcedBlock)rb;
                if (!reinforcedBlock.getVanillaBlocks().contains(event.getState().func_177230_c())) continue;
                event.setNewSpeed(10000.0f);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof EntityWither && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c().equals((Object)event.getTarget().func_178782_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && BlockUtils.getBlock((World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v))) instanceof BlockSecurityCamera) {
                GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.getResolution(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v)));
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            World world = player.func_130014_f_();
            int held = player.field_71071_by.field_70461_c;
            if (held < 0 || held >= player.field_71071_by.field_70462_a.size()) {
                return;
            }
            ItemStack monitor = (ItemStack)player.field_71071_by.field_70462_a.get(held);
            if (!monitor.func_190926_b() && monitor.func_77973_b() == SCContent.cameraMonitor) {
                String textureToUse = "camera_not_bound";
                double eyeHeight = player.func_70047_e();
                Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                RayTraceResult mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_178782_a()) instanceof TileEntitySecurityCamera) {
                    NBTTagCompound cameras = monitor.func_77978_p();
                    if (cameras != null) {
                        for (int i = 1; i < 31; ++i) {
                            String[] coords;
                            if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_178782_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_178782_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_178782_a().func_177952_p()) continue;
                            textureToUse = "camera_bound";
                            break;
                        }
                    }
                    GlStateManager.func_179141_d();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    this.drawNonStandardTexturedRect(event.getResolution().func_78326_a() / 2 - 90 + held * 20 + 2, event.getResolution().func_78328_b() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GlStateManager.func_179118_c();
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntity())) {
            event.setNewfov(((EntitySecurityCamera)event.getEntity().func_184187_bx()).getZoomAmount());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && event.getButton() != 1) {
            event.setCanceled(true);
        }
    }

    private void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), z).func_187315_a((double)u * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)(u + width) * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, z).func_187315_a((double)(u + width) * widthFactor, (double)v * heightFactor).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, z).func_187315_a((double)u * widthFactor, (double)v * heightFactor).func_181675_d();
        tessellator.func_78381_a();
    }

    private ItemStack fillBucket(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == SCContent.bogusWater) {
            world.func_175698_g(pos);
            return new ItemStack(SCContent.fWaterBucket, 1);
        }
        if (block == SCContent.bogusLava) {
            world.func_175698_g(pos);
            return new ItemStack(SCContent.fLavaBucket, 1);
        }
        return ItemStack.field_190927_a;
    }

    private void handleOwnableTEs(BlockEvent.PlaceEvent event) {
        if (event.getWorld().func_175625_s(event.getPos()) instanceof IOwnable) {
            String name = event.getPlayer().func_70005_c_();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)event.getWorld().func_175625_s(event.getPos())).getOwner().set(uuid, name);
        }
    }

    private boolean handleCodebreaking(PlayerInteractEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        TileEntity tileEntity = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos());
        if (ConfigHandler.allowCodebreakerItem && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.codebreaker) {
            event.getEntityPlayer().func_184586_b(event.getHand()).func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
        }
        if (tileEntity != null && tileEntity instanceof IPasswordProtected && new Random().nextInt(3) == 1) {
            return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getEntityPlayer(), !ConfigHandler.allowCodebreakerItem);
        }
        return false;
    }

    private String getRandomTip() {
        String[] tips = new String[]{"messages.tip.scHelp", "messages.tip.trello", "messages.tip.patreon", "messages.tip.discord", "messages.tip.scserver"};
        return tips[new Random().nextInt(tips.length)];
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof TileEntityOwnable || tileEntity instanceof IOwnable || block instanceof BlockOwnable;
    }
}

