/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCageTrap
extends BlockOwnable
implements IIntersectable {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockCageTrap(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        if (BlockUtils.getBlock(world, pos) == SCContent.cageTrap && !BlockUtils.getBlockPropertyAsBoolean(world, pos, DEACTIVATED)) {
            return null;
        }
        return blockState.func_185900_c(world, pos);
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            TileEntityCageTrap tileEntity = (TileEntityCageTrap)world.func_175625_s(pos);
            boolean isPlayer = entity instanceof EntityPlayer;
            boolean shouldCaptureMobs = tileEntity.getOptionByName("captureMobs").asBoolean();
            if (isPlayer || entity instanceof EntityMob && shouldCaptureMobs) {
                if (isPlayer && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)entity)) {
                    return;
                }
                if (BlockUtils.getBlockPropertyAsBoolean(world, pos, DEACTIVATED)) {
                    return;
                }
                BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
                BlockUtils.setBlock(world, pos.func_177981_b(4), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n() + 1, pos.func_177956_o() + 4, pos.func_177952_p(), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n() - 1, pos.func_177956_o() + 4, pos.func_177952_p(), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n(), pos.func_177956_o() + 4, pos.func_177952_p() + 1, SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n(), pos.func_177956_o() + 4, pos.func_177952_p() - 1, SCContent.reinforcedIronBars);
                BlockUtils.setBlockInBox(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), SCContent.reinforcedIronBars);
                this.setTileEntities(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((IOwnable)world.func_175625_s(pos)).getOwner().getUUID(), ((IOwnable)world.func_175625_s(pos)).getOwner().getName());
                world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 3.0f, 1.0f);
                if (isPlayer) {
                    world.func_73046_m().func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.BLACK + ClientUtils.localize("tile.securitycraft:cageTrap.name", new Object[0]) + TextFormatting.RESET + "] " + ClientUtils.localize("messages.securitycraft:cageTrap.captured", new Object[0]).replace("#player", ((EntityPlayer)entity).func_70005_c_()).replace("#location", Utils.getFormattedCoordinates(pos)), new Object[0]));
                }
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCageTrap().intersectsEntities();
    }

    public void setTileEntities(World world, int x, int y, int z, String uuid, String name) {
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z - 1))).getOwner().set(uuid, name);
    }
}

