/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScannerField;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BlockInventoryScanner
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockInventoryScanner(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState north = world.func_180495_p(pos.func_177978_c());
            IBlockState south = world.func_180495_p(pos.func_177968_d());
            IBlockState west = world.func_180495_p(pos.func_177976_e());
            IBlockState east = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isFacingAnotherScanner(world, pos)) {
            player.openGui((Object)SecurityCraft.instance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize("tile.securitycraft:inventoryScanner.name", new Object[0]), ClientUtils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), TextFormatting.RED);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        this.checkAndPlaceAppropriately(world, pos);
    }

    private void checkAndPlaceAppropriately(World world, BlockPos pos) {
        int i;
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
        if (connectedScanner == null) {
            return;
        }
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        int loopBoundary = facing == EnumFacing.WEST || facing == EnumFacing.EAST ? Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()) : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()) : 0);
        for (i = 1; i < loopBoundary; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.inventoryScannerField) continue;
            return;
        }
        for (i = 1; i < loopBoundary; ++i) {
            world.func_175656_a(pos.func_177967_a(facing, i), SCContent.inventoryScannerField.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing));
        }
        CustomizableSCTE.link((CustomizableSCTE)world.func_175625_s(pos), connectedScanner);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityInventoryScanner connectedScanner = null;
        block0: for (EnumFacing facing : EnumFacing.field_176754_o) {
            for (int i = 1; i <= ConfigHandler.inventoryScannerRange; ++i) {
                BlockPos offsetIPos = pos.func_177967_a(facing, i);
                if (BlockUtils.getBlock(world, offsetIPos) != SCContent.inventoryScanner) continue;
                for (int j = 1; j < i; ++j) {
                    BlockPos offsetJPos = pos.func_177967_a(facing, j);
                    IBlockState field = world.func_180495_p(offsetJPos);
                    if (field.func_177230_c() != SCContent.inventoryScannerField) continue;
                    if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                        if (field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.WEST && field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.EAST) continue;
                        world.func_175655_b(offsetJPos, false);
                        continue;
                    }
                    if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH || field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.NORTH && field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.SOUTH) continue;
                    world.func_175655_b(offsetJPos, false);
                }
                connectedScanner = (TileEntityInventoryScanner)world.func_175625_s(offsetIPos);
                continue block0;
            }
        }
        if (connectedScanner != null) {
            for (int i = 0; i < connectedScanner.getContents().size(); ++i) {
                connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    private boolean isFacingAnotherScanner(World world, BlockPos pos) {
        return BlockInventoryScanner.getConnectedInventoryScanner(world, pos) != null;
    }

    public static TileEntityInventoryScanner getConnectedInventoryScanner(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        for (int i = 0; i <= ConfigHandler.inventoryScannerRange; ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            Block block = BlockUtils.getBlock(world, offsetPos);
            IBlockState state = world.func_180495_p(offsetPos);
            if (block != Blocks.field_150350_a && block != SCContent.inventoryScannerField && block != SCContent.inventoryScanner) {
                return null;
            }
            if (block != SCContent.inventoryScanner || state.func_177229_b((IProperty)FACING) != facing.func_176734_d()) continue;
            return (TileEntityInventoryScanner)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!(blockAccess.func_175625_s(pos) instanceof TileEntityInventoryScanner) || ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType() == null) {
            SecurityCraft.log("type is null on the " + FMLCommonHandler.instance().getEffectiveSide() + " side");
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType().equals("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getType().equals("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityInventoryScanner();
    }
}

