/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBouncingBetty
extends BlockExplosive
implements IIntersectable {
    public static final PropertyBool DEACTIVATED = PropertyBool.func_177716_a((String)"deactivated");

    public BlockBouncingBetty(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.2f, (double)0.8f);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.explode(world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (BlockUtils.getBlockPropertyAsBoolean(world, pos, DEACTIVATED)) {
            return;
        }
        world.func_175698_g(pos);
        EntityBouncingBetty imsBomb = new EntityBouncingBetty(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        imsBomb.fuse = 15;
        imsBomb.field_70181_x = 0.5;
        WorldUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)imsBomb));
        imsBomb.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("game.tnt.primed")), 1.0f, 1.0f);
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOwnable().intersectsEntities();
    }
}

