/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.compat.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        SecurityCraft.log("Adding Waila support!");
        registrar.addConfig("SecurityCraft", "securitycraft.showowner", ClientUtils.localize("waila.securitycraft:displayOwner", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showmodules", ClientUtils.localize("waila.securitycraft:showModules", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showpasswords", ClientUtils.localize("waila.securitycraft:showPasswords", new Object[0]));
        registrar.addConfig("SecurityCraft", "securitycraft.showcustomname", ClientUtils.localize("waila.securitycraft:showCustomName", new Object[0]));
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)new WailaDataProvider(), ICustomWailaDisplay.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof ICustomWailaDisplay) {
            return ((ICustomWailaDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> head, IWailaDataAccessor data, IWailaConfigHandler config) {
        return head;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> body, IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof ICustomWailaDisplay && !((ICustomWailaDisplay)data.getBlock()).shouldShowSCInfo(data.getWorld(), data.getBlockState(), data.getPosition())) {
            return body;
        }
        if (config.getConfig("securitycraft.showowner") && data.getTileEntity() instanceof IOwnable) {
            body.add(ClientUtils.localize("waila.securitycraft:owner", new Object[0]) + " " + ((IOwnable)data.getTileEntity()).getOwner().getName());
        }
        if (config.getConfig("securitycraft.showmodules") && data.getTileEntity() instanceof CustomizableSCTE && ((CustomizableSCTE)data.getTileEntity()).getOwner().isOwner(data.getPlayer())) {
            if (!((CustomizableSCTE)data.getTileEntity()).getModules().isEmpty()) {
                body.add(ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
            }
            for (EnumCustomModules module : ((CustomizableSCTE)data.getTileEntity()).getModules()) {
                body.add("- " + module.getName());
            }
        }
        if (config.getConfig("securitycraft.showpasswords") && data.getTileEntity() instanceof IPasswordProtected && !(data.getTileEntity() instanceof TileEntityKeycardReader) && ((IOwnable)data.getTileEntity()).getOwner().isOwner(data.getPlayer())) {
            String password = ((IPasswordProtected)data.getTileEntity()).getPassword();
            body.add(ClientUtils.localize("waila.securitycraft:password", new Object[0]) + " " + (password != null && !password.isEmpty() ? password : ClientUtils.localize("waila.securitycraft:password.notSet", new Object[0])));
        }
        if (config.getConfig("securitycraft.showcustomname") && data.getTileEntity() instanceof INameable && ((INameable)data.getTileEntity()).canBeNamed()) {
            String name = ((INameable)data.getTileEntity()).getCustomName();
            body.add(ClientUtils.localize("waila.securitycraft:customName", new Object[0]) + " " + (((INameable)data.getTileEntity()).hasCustomName() ? name : ClientUtils.localize("waila.securitycraft:customName.notSet", new Object[0])));
        }
        return body;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tail, IWailaDataAccessor data, IWailaConfigHandler config) {
        return tail;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }
}

