/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetISType
implements IMessage {
    private int x;
    private int y;
    private int z;
    private String type;

    public PacketSetISType() {
    }

    public PacketSetISType(int x, int y, int z, String type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.type);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetISType, IMessage> {
        public IMessage onMessage(PacketSetISType message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
                ((TileEntityInventoryScanner)this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b).func_175625_s(pos)).setType(message.type);
                SecurityCraft.log("Setting type to " + message.type);
                this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b).func_175684_a(pos, BlockUtils.getBlock(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), pos), 1);
                Utils.setISinTEAppropriately(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), pos, ((TileEntityInventoryScanner)this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b).func_175625_s(pos)).getContents(), ((TileEntityInventoryScanner)this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b).func_175625_s(pos)).getType());
            });
            return null;
        }
    }
}

