/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetKeycardLevel
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int level;
    private boolean exactCard;

    public PacketSetKeycardLevel() {
    }

    public PacketSetKeycardLevel(int x, int y, int z, int level, boolean exactCard) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = level;
        this.exactCard = exactCard;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.level);
        buf.writeBoolean(this.exactCard);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.level = buf.readInt();
        this.exactCard = buf.readBoolean();
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSetKeycardLevel, IMessage> {
        public IMessage onMessage(PacketSetKeycardLevel message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
                int level = message.level;
                boolean exactCard = message.exactCard;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                ((TileEntityKeycardReader)this.getWorld((EntityPlayer)player).func_175625_s(pos)).setPassword(String.valueOf(level));
                ((TileEntityKeycardReader)this.getWorld((EntityPlayer)player).func_175625_s(pos)).setRequiresExactKeycard(exactCard);
            });
            return null;
        }
    }
}

