/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockInventoryScannerField;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class TileEntityInventoryScanner
extends CustomizableSCTE
implements IInventory {
    private NonNullList<ItemStack> inventoryContents = NonNullList.func_191197_a((int)37, (Object)ItemStack.field_190927_a);
    private String type = "check";
    private boolean isProvidingPower;
    private int cooldown;

    @Override
    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c(), 1, true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.inventoryContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)new ItemStack(stackTag));
        }
        if (tag.func_74764_b("cooldown")) {
            this.cooldown = tag.func_74762_e("cooldown");
        }
        if (tag.func_74764_b("type")) {
            this.type = tag.func_74779_i("type");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74778_a("type", this.type);
        return tag;
    }

    @Override
    public int func_70302_i_() {
        return 37;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).func_190926_b()) {
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).func_77979_a(count);
            if (((ItemStack)this.inventoryContents.get(index)).func_190916_E() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        if (!((ItemStack)this.inventoryContents.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.inventoryContents.get(index);
            this.inventoryContents.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).func_190926_b(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.func_190926_b() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.func_70301_a(slot);
        int limit = stackToInsert.func_77973_b().getItemStackLimit(stackToInsert);
        if (slotStack.func_190926_b()) {
            this.func_70299_a(slot, stackToInsert);
            return ItemStack.field_190927_a;
        }
        if (BlockInventoryScannerField.areItemStacksEqual(slotStack, stackToInsert) && slotStack.func_190916_E() < limit) {
            if (limit - slotStack.func_190916_E() >= stackToInsert.func_190916_E()) {
                slotStack.func_190920_e(slotStack.func_190916_E() + stackToInsert.func_190916_E());
                return ItemStack.field_190927_a;
            }
            ItemStack toInsert = stackToInsert.func_77946_l();
            ItemStack toReturn = toInsert.func_77979_a(slotStack.func_190916_E() + stackToInsert.func_190916_E() - limit);
            slotStack.func_190920_e(slotStack.func_190916_E() + toInsert.func_190916_E());
            return toReturn;
        }
        return stackToInsert;
    }

    public void clearStorage() {
        for (int i = 10; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).func_190926_b()) continue;
            this.inventoryContents.set(i, (Object)ItemStack.field_190927_a);
            break;
        }
        this.func_70296_d();
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean shouldProvidePower() {
        return this.type.equals("redstone") && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && !connectedScanner.hasModule(module)) {
            connectedScanner.insertModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(this.field_145850_b, this.field_174879_c);
        if (connectedScanner != null && connectedScanner.hasModule(module)) {
            connectedScanner.removeModule(module);
        }
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.WHITELIST, EnumCustomModules.SMART, EnumCustomModules.STORAGE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }
}

