/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;

public class TileEntityRetinalScanner
extends CustomizableSCTE {
    private Option.OptionBoolean activatedByEntities = new Option.OptionBoolean("activatedByEntities", false);

    @Override
    public void entityViewed(EntityLivingBase entity) {
        if (!this.field_145850_b.field_72995_K && !BlockUtils.getBlockPropertyAsBoolean(this.field_145850_b, this.field_174879_c, BlockRetinalScanner.POWERED)) {
            if (!(entity instanceof EntityPlayer) && !this.activatedByEntities.asBoolean()) {
                return;
            }
            if (entity instanceof EntityPlayer && PlayerUtils.isPlayerMountedOnCamera(entity)) {
                return;
            }
            if (entity instanceof EntityPlayer && !this.getOwner().isOwner((EntityPlayer)entity) && !ModuleUtils.checkForModule(this.field_145850_b, this.field_174879_c, (EntityPlayer)entity, EnumCustomModules.WHITELIST)) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)entity, ClientUtils.localize("tile.securitycraft:retinalScanner.name", new Object[0]), ClientUtils.localize("messages.securitycraft:retinalScanner.notOwner", new Object[0]).replace("#", this.getOwner().getName()), TextFormatting.RED);
                return;
            }
            BlockUtils.setBlockProperty(this.field_145850_b, this.field_174879_c, BlockRetinalScanner.POWERED, true);
            this.field_145850_b.func_175684_a(new BlockPos((Vec3i)this.field_174879_c), SCContent.retinalScanner, 60);
            if (entity instanceof EntityPlayer) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)entity, ClientUtils.localize("tile.securitycraft:retinalScanner.name", new Object[0]), ClientUtils.localize("messages.securitycraft:retinalScanner.hello", new Object[0]).replace("#", entity.func_70005_c_()), TextFormatting.GREEN);
            }
        }
    }

    @Override
    public int getViewCooldown() {
        return 30;
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return !this.activatedByEntities.asBoolean();
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities};
    }
}

