/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.List;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerUtils {
    public static EntityPlayer getPlayerFromName(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            List players = Minecraft.func_71410_x().field_71441_e.field_73010_i;
            for (EntityPlayer tempPlayer : players) {
                if (!tempPlayer.func_70005_c_().equals(name)) continue;
                return tempPlayer;
            }
            return null;
        }
        List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        for (EntityPlayer tempPlayer : players) {
            if (!tempPlayer.func_70005_c_().equals(name)) continue;
            return tempPlayer;
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i);
                if (player == null || !player.func_70005_c_().equals(name)) continue;
                return true;
            }
            return false;
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(name) != null;
    }

    public static void sendMessageToPlayer(EntityPlayer player, String prefix, String text, TextFormatting color) {
        player.func_145747_a((ITextComponent)new TextComponentString("[" + color + prefix + TextFormatting.WHITE + "] " + text));
    }

    public static void sendMessageEndingWithLink(ICommandSender sender, String prefix, String text, String link, TextFormatting color) {
        sender.func_145747_a(new TextComponentString("[" + color + prefix + TextFormatting.WHITE + "] " + text + ": ").func_150257_a(ForgeHooks.newChatWithLinks((String)link)));
    }

    public static boolean isHoldingItem(EntityPlayer player, Item item) {
        if (item == null && player.field_71071_by.func_70448_g().func_190926_b()) {
            return true;
        }
        return !player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == item;
    }

    public static boolean isPlayerMountedOnCamera(EntityLivingBase entity) {
        return entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntitySecurityCamera;
    }
}

