/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {

    public static class CommonConfig {
        public static final ForgeConfigSpec CONFIG_SPEC;
        public static final CommonConfig CONFIG;
        public ForgeConfigSpec.BooleanValue allowCodebreakerItem;
        public ForgeConfigSpec.BooleanValue allowAdminTool;
        public ForgeConfigSpec.BooleanValue shouldSpawnFire;
        public ForgeConfigSpec.BooleanValue ableToBreakMines;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard1;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard2;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard3;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard4;
        public ForgeConfigSpec.BooleanValue ableToCraftKeycard5;
        public ForgeConfigSpec.BooleanValue ableToCraftLUKeycard;
        public ForgeConfigSpec.BooleanValue smallerMineExplosion;
        public ForgeConfigSpec.BooleanValue mineExplodesWhenInCreative;
        public ForgeConfigSpec.DoubleValue portableRadarSearchRadius;
        public ForgeConfigSpec.IntValue usernameLoggerSearchRadius;
        public ForgeConfigSpec.IntValue laserBlockRange;
        public ForgeConfigSpec.IntValue alarmTickDelay;
        public ForgeConfigSpec.IntValue portableRadarDelay;
        public ForgeConfigSpec.IntValue claymoreRange;
        public ForgeConfigSpec.IntValue imsRange;
        public ForgeConfigSpec.IntValue inventoryScannerRange;
        public ForgeConfigSpec.DoubleValue motionActivatedLightSearchRadius;
        public ForgeConfigSpec.BooleanValue debug;
        public ForgeConfigSpec.BooleanValue allowBlockClaim;
        public ForgeConfigSpec.BooleanValue sayThanksMessage;
        public ForgeConfigSpec.BooleanValue checkForUpdates;
        public ForgeConfigSpec.DoubleValue alarmSoundVolume;
        public ForgeConfigSpec.DoubleValue cameraSpeed;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.allowCodebreakerItem = builder.translation("config.securitycraft:isCodebreakerAllowed").comment("Can the codebreaker be used?").define("allowCodebreakerItem", true);
            this.allowAdminTool = builder.translation("config.securitycraft:allowAdminTool").comment("Can the admin tool be used?").define("allowAdminTool", false);
            this.shouldSpawnFire = builder.translation("config.securitycraft:shouldSpawnFire").comment("Should mines spawn fire after exploding?").define("shouldSpawnFire", true);
            this.ableToBreakMines = builder.translation("config.securitycraft:ableToBreakMines").comment("Should players be able to break a mine without it exploding?").worldRestart().define("ableToBreakMines", true);
            this.ableToCraftKeycard1 = builder.translation("config.securitycraft:ableToCraftKeycard1").comment("Is the level 1 keycard craftable?").worldRestart().define("ableToCraftKeycard1", true);
            this.ableToCraftKeycard2 = builder.translation("config.securitycraft:ableToCraftKeycard2").comment("Is the level 2 keycard craftable?").worldRestart().define("ableToCraftKeycard2", true);
            this.ableToCraftKeycard3 = builder.translation("config.securitycraft:ableToCraftKeycard3").comment("Is the level 3 keycard craftable?").worldRestart().define("ableToCraftKeycard3", true);
            this.ableToCraftKeycard4 = builder.translation("config.securitycraft:ableToCraftKeycard4").comment("Is the level 4 keycard craftable?").worldRestart().define("ableToCraftKeycard4", true);
            this.ableToCraftKeycard5 = builder.translation("config.securitycraft:ableToCraftKeycard5").comment("Is the level 5 keycard craftable?").worldRestart().define("ableToCraftKeycard5", true);
            this.ableToCraftLUKeycard = builder.translation("config.securitycraft:ableToCraftLUKeycard").comment("Is the limited use keycard craftable?").worldRestart().define("ableToCraftLUKeycard", true);
            this.smallerMineExplosion = builder.translation("config.securitycraft:smallerMineExplosion").comment("Should mines' explosions be smaller than usual.").define("smallerMineExplosion", false);
            this.mineExplodesWhenInCreative = builder.translation("config.securitycraft:mineExplodesWhenInCreative").comment("Should mines explode if broken while in Creative mode?").define("mineExplodesWhenInCreative", true);
            this.portableRadarSearchRadius = builder.translation("config.securitycraft:portableRadarSearchRadius").comment("From how many blocks can the portable radar detect players?").defineInRange("portableRadarSearchRadius", 25.0, 0.0, Double.MAX_VALUE);
            this.usernameLoggerSearchRadius = builder.translation("config.securitycraft:usernameLoggerSearchRadius").comment("From how many blocks can the username logger detect players?").defineInRange("usernameLoggerSearchRadius", 3, 0, Integer.MAX_VALUE);
            this.laserBlockRange = builder.translation("config.securitycraft:laserBlockRange").comment("From how many blocks away can a laser block connect to another laser block?").defineInRange("laserBlockRange", 5, 0, Integer.MAX_VALUE);
            this.alarmTickDelay = builder.translation("config.securitycraft:alarmTickDelay").comment("If an alarm is activated, how many seconds in-between alarm sounds effects?").defineInRange("alarmTickDelay", 2, 0, Integer.MAX_VALUE);
            this.portableRadarDelay = builder.translation("config.securitycraft:portableRadarDelay").comment("If a portable radar is activated, how many seconds should pass before the radar searches again?").defineInRange("portableRadarDelay", 4, 0, Integer.MAX_VALUE);
            this.claymoreRange = builder.translation("config.securitycraft:claymoreRange").comment("From how many blocks can the claymore mine be tripped from?").defineInRange("claymoreRange", 5, 0, Integer.MAX_VALUE);
            this.imsRange = builder.translation("config.securitycraft:imsRange").comment("How many blocks away can the I.M.S. detect players from?").defineInRange("imsRange", 12, 0, Integer.MAX_VALUE);
            this.inventoryScannerRange = builder.translation("config.securitycraft:inventoryScannerRange").comment("From how many blocks away can an inventory scanner connect to another inventory scanner?").defineInRange("inventoryScannerRange", 2, 0, Integer.MAX_VALUE);
            this.motionActivatedLightSearchRadius = builder.translation("config.securitycraft:motionActivatedLightSearchRadius").comment("How many blocks away can the Motion Activated Light detect entities from?").defineInRange("motionActivatedLightSearchRadius", 5.0, 0.0, Double.MAX_VALUE);
            this.debug = builder.translation("config.securitycraft:debuggingMode").comment("Should SecurityCraft run in debug mode? (logs extra things to the console, may add unfinished items/blocks that could be buggy.)").define("debuggingMode", false);
            this.allowBlockClaim = builder.translation("config.securitycraft:allowBlockClaim").comment("Allow claiming unowned blocks?").define("allowBlockClaim", false);
            this.sayThanksMessage = builder.translation("config.securitycraft:sayThanksMessage").comment("Display a 'tip' message at spawn?").define("sayThanksMessage", true);
            this.checkForUpdates = builder.translation("config.securitycraft:checkForUpdates").comment("Should SecurityCraft check for new updates of the mod through SecurityCraft's GitHub repository?").define("checkForUpdates", true);
            this.alarmSoundVolume = builder.translation("config.securitycraft:alarmSoundVolume").comment("What volume should the alarm sound effect be played at?").defineInRange("alarmSoundVolume", 0.3, 0.0, Double.MAX_VALUE);
            this.cameraSpeed = builder.translation("config.securitycraft:cameraSpeed").comment("How fast can you rotate when mounted to a camera and holding W-A-S-D?").defineInRange("cameraSpeed", 2.0, 0.0, Double.MAX_VALUE);
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
            CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
            CONFIG = (CommonConfig)specPair.getLeft();
        }
    }
}

