/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.SetupHandler;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.entity.EntityTaserBullet;
import net.geforcemods.securitycraft.items.ItemReinforcedBlock;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.ClearLoggerClient;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.network.client.SetPlayerPositionAndRotation;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.client.UpdateTEOwnable;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.CloseFurnace;
import net.geforcemods.securitycraft.network.server.GivePotionEffect;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.OpenGui;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RequestTEOwnableUpdate;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetCameraRotation;
import net.geforcemods.securitycraft.network.server.SetExplosiveState;
import net.geforcemods.securitycraft.network.server.SetKeycardLevel;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.network.server.SetScanType;
import net.geforcemods.securitycraft.network.server.SyncTENBTTag;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.tileentity.TileEntityClaymore;
import net.geforcemods.securitycraft.tileentity.TileEntityIMS;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.geforcemods.securitycraft.tileentity.TileEntityLogger;
import net.geforcemods.securitycraft.tileentity.TileEntityMotionLight;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityPortableRadar;
import net.geforcemods.securitycraft.tileentity.TileEntityProtecto;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedPressurePlate;
import net.geforcemods.securitycraft.tileentity.TileEntityRetinalScanner;
import net.geforcemods.securitycraft.tileentity.TileEntityScannerDoor;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntityTrackMine;
import net.geforcemods.securitycraft.tileentity.TileEntityTrophySystem;
import net.geforcemods.securitycraft.util.RegisterItemBlock;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrationHandler {
    private static ArrayList<Block> blockPages = new ArrayList();
    private static Map<Block, String> blocksDesignedBy = new HashMap<Block, String>();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        SetupHandler.setupFluids();
        SetupHandler.setupBlocks();
        SetupHandler.setupReinforcedBlocks();
        SetupHandler.setupMines();
        IRegistry.field_212619_h.func_82595_a(new ResourceLocation("securitycraft", "flowing_fake_water"), (Object)SCContent.flowingFakeWater);
        IRegistry.field_212619_h.func_82595_a(new ResourceLocation("securitycraft", "fake_water"), (Object)SCContent.fakeWater);
        IRegistry.field_212619_h.func_82595_a(new ResourceLocation("securitycraft", "flowing_fake_lava"), (Object)SCContent.flowingFakeLava);
        IRegistry.field_212619_h.func_82595_a(new ResourceLocation("securitycraft", "fake_lava"), (Object)SCContent.fakeLava);
        RegistrationHandler.registerBlock(event, SCContent.laserBlock);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.laserField);
        RegistrationHandler.registerBlock(event, SCContent.keypad);
        RegistrationHandler.registerBlock(event, (Block)SCContent.mine);
        RegistrationHandler.registerBlock(event, SCContent.dirtMine);
        RegistrationHandler.registerBlock(event, SCContent.stoneMine, false);
        RegistrationHandler.registerBlock(event, SCContent.cobblestoneMine, false);
        RegistrationHandler.registerBlock(event, SCContent.diamondOreMine, false);
        RegistrationHandler.registerBlock(event, SCContent.sandMine, false);
        RegistrationHandler.registerBlock(event, SCContent.furnaceMine);
        RegistrationHandler.registerBlock(event, SCContent.retinalScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.reinforcedDoor);
        RegistrationHandler.registerBlock(event, SCContent.keycardReader);
        RegistrationHandler.registerBlock(event, SCContent.ironTrapdoor);
        RegistrationHandler.registerBlock(event, SCContent.bouncingBetty);
        RegistrationHandler.registerBlock(event, SCContent.inventoryScanner);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.inventoryScannerField);
        RegistrationHandler.registerBlock(event, SCContent.trackMine);
        RegistrationHandler.registerBlock(event, SCContent.cageTrap);
        RegistrationHandler.registerBlock(event, SCContent.portableRadar);
        RegistrationHandler.registerBlock(event, SCContent.keypadChest);
        RegistrationHandler.registerBlock(event, SCContent.usernameLogger);
        RegistrationHandler.registerBlock(event, SCContent.alarm);
        RegistrationHandler.registerBlock(event, SCContent.reinforcedFencegate);
        RegistrationHandler.registerBlock(event, SCContent.panicButton);
        RegistrationHandler.registerBlock(event, SCContent.frame);
        RegistrationHandler.registerBlock(event, SCContent.claymore);
        RegistrationHandler.registerBlock(event, SCContent.keypadFurnace);
        RegistrationHandler.registerBlock(event, SCContent.securityCamera);
        RegistrationHandler.registerBlock(event, SCContent.ironFence);
        RegistrationHandler.registerBlock(event, SCContent.ims);
        RegistrationHandler.registerBlock(event, SCContent.protecto);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.scannerDoor);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignWall);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.secretSignStanding);
        RegistrationHandler.registerBlock(event, SCContent.motionActivatedLight);
        RegistrationHandler.registerBlock(event, SCContent.gravelMine, false);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeLavaBlock, false);
        RegistrationHandler.registerBlock(event, (Block)SCContent.fakeWaterBlock, false);
        RegistrationHandler.registerBlock(event, SCContent.trophySystem);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartz, true);
        RegistrationHandler.registerBlock(event, SCContent.chiseledCrystalQuartz, false);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartzPillar, false);
        RegistrationHandler.registerBlock(event, SCContent.crystalQuartzSlab, false);
        RegistrationHandler.registerBlock(event, SCContent.stairsCrystalQuartz, false);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketWall);
        RegistrationHandler.registerBlock(event, SCContent.blockPocketManager, "Henzoid");
        for (Field field : SCContent.class.getFields()) {
            try {
                if (!field.isAnnotationPresent(Reinforced.class)) continue;
                RegistrationHandler.registerBlock(event, (Block)field.get(null), field.getAnnotation(Reinforced.class).hasPage());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        SetupHandler.setupItems();
        for (Field field : SCContent.class.getFields()) {
            try {
                if (field.isAnnotationPresent(Reinforced.class)) {
                    event.getRegistry().register((IForgeRegistryEntry)new ItemReinforcedBlock((Block)field.get(null)));
                    continue;
                }
                if (!field.isAnnotationPresent(RegisterItemBlock.class)) continue;
                int tab = field.getAnnotation(RegisterItemBlock.class).value().ordinal();
                Block block = (Block)field.get(null);
                event.getRegistry().register(new ItemBlock(block, new Item.Properties().func_200916_a(tab == 0 ? SecurityCraft.groupSCTechnical : (tab == 1 ? SecurityCraft.groupSCMine : SecurityCraft.groupSCDecoration))).setRegistryName(block.getRegistryName()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        SecurityCraft.proxy.registerKeypadChestItem(event);
        for (Block block : blockPages) {
            if (block == SCContent.reinforcedStone) {
                SecurityCraft.instance.manualPages.add(new SCManualPage(block.func_199767_j(), "help.securitycraft:reinforced.info"));
                continue;
            }
            SCManualPage page = new SCManualPage(block.func_199767_j(), "help" + block.func_149739_a().substring(5) + ".info");
            if (blocksDesignedBy.containsKey(block)) {
                page.setDesignedBy(blocksDesignedBy.get(block));
            }
            SecurityCraft.instance.manualPages.add(page);
        }
        RegistrationHandler.registerItem(event, SCContent.codebreaker);
        RegistrationHandler.registerItem(event, SCContent.reinforcedDoorItem);
        RegistrationHandler.registerItem(event, SCContent.scannerDoorItem);
        RegistrationHandler.registerItem(event, SCContent.universalBlockRemover);
        RegistrationHandler.registerItem(event, SCContent.keycardLvl1, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftKeycard1.get());
        RegistrationHandler.registerItem(event, SCContent.keycardLvl2, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftKeycard2.get());
        RegistrationHandler.registerItem(event, SCContent.keycardLvl3, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftKeycard3.get());
        RegistrationHandler.registerItem(event, SCContent.keycardLvl4, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftKeycard4.get());
        RegistrationHandler.registerItem(event, SCContent.keycardLvl5, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftKeycard5.get());
        RegistrationHandler.registerItem(event, SCContent.limitedUseKeycard, () -> (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToCraftLUKeycard.get());
        RegistrationHandler.registerItem(event, SCContent.remoteAccessMine);
        RegistrationHandler.registerItem(event, SCContent.fWaterBucket);
        RegistrationHandler.registerItem(event, SCContent.fLavaBucket);
        RegistrationHandler.registerItem(event, SCContent.universalBlockModifier);
        RegistrationHandler.registerItem(event, SCContent.redstoneModule);
        RegistrationHandler.registerItem(event, SCContent.whitelistModule);
        RegistrationHandler.registerItem(event, SCContent.blacklistModule);
        RegistrationHandler.registerItem(event, SCContent.harmingModule);
        RegistrationHandler.registerItem(event, SCContent.smartModule);
        RegistrationHandler.registerItem(event, SCContent.storageModule);
        RegistrationHandler.registerItem(event, SCContent.disguiseModule);
        RegistrationHandler.registerItem(event, SCContent.wireCutters);
        RegistrationHandler.registerItem(event, SCContent.adminTool);
        RegistrationHandler.registerItem(event, SCContent.keyPanel);
        RegistrationHandler.registerItem(event, SCContent.cameraMonitor);
        RegistrationHandler.registerItem(event, SCContent.taser);
        RegistrationHandler.registerItem(event, SCContent.scManual);
        RegistrationHandler.registerItem(event, SCContent.universalOwnerChanger);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL1);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL2);
        RegistrationHandler.registerItem(event, SCContent.universalBlockReinforcerLvL3);
        RegistrationHandler.registerItem(event, SCContent.briefcase);
        RegistrationHandler.registerItem(event, SCContent.universalKeyChanger);
        event.getRegistry().register((IForgeRegistryEntry)SCContent.taserPowered);
        RegistrationHandler.registerItem(event, SCContent.secretSignItem);
        RegistrationHandler.registerItem(event, SCContent.sentry, "Henzoid");
        RegistrationHandler.registerItem(event, SCContent.crystalQuartzItem);
        blockPages = null;
        blocksDesignedBy = null;
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        SCContent.teTypeOwnable = TileEntityType.func_200966_a((String)"securitycraft:ownable", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityOwnable::new));
        SCContent.teTypeAbstract = TileEntityType.func_200966_a((String)"securitycraft:abstract", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntitySCTE::new));
        SCContent.teTypeKeypad = TileEntityType.func_200966_a((String)"securitycraft:keypad", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityKeypad::new));
        SCContent.teTypeLaserBlock = TileEntityType.func_200966_a((String)"securitycraft:laser_block", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityLaserBlock::new));
        SCContent.teTypeCageTrap = TileEntityType.func_200966_a((String)"securitycraft:cage_trap", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityCageTrap::new));
        SCContent.teTypeKeycardReader = TileEntityType.func_200966_a((String)"securitycraft:keycard_reader", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityKeycardReader::new));
        SCContent.teTypeInventoryScanner = TileEntityType.func_200966_a((String)"securitycraft:inventory_scanner", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityInventoryScanner::new));
        SCContent.teTypePortableRadar = TileEntityType.func_200966_a((String)"securitycraft:portable_radar", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityPortableRadar::new));
        SCContent.teTypeSecurityCamera = TileEntityType.func_200966_a((String)"securitycraft:security_camera", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntitySecurityCamera::new));
        SCContent.teTypeUsernameLogger = TileEntityType.func_200966_a((String)"securitycraft:username_logger", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityLogger::new));
        SCContent.teTypeRetinalScanner = TileEntityType.func_200966_a((String)"securitycraft:retinal_scanner", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityRetinalScanner::new));
        SCContent.teTypeKeypadChest = TileEntityType.func_200966_a((String)"securitycraft:keypad_chest", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityKeypadChest::new));
        SCContent.teTypeAlarm = TileEntityType.func_200966_a((String)"securitycraft:alarm", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityAlarm::new));
        SCContent.teTypeClaymore = TileEntityType.func_200966_a((String)"securitycraft:claymore", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityClaymore::new));
        SCContent.teTypeKeypadFurnace = TileEntityType.func_200966_a((String)"securitycraft:keypad_furnace", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityKeypadFurnace::new));
        SCContent.teTypeIms = TileEntityType.func_200966_a((String)"securitycraft:ims", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityIMS::new));
        SCContent.teTypeProtecto = TileEntityType.func_200966_a((String)"securitycraft:protecto", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityProtecto::new));
        SCContent.teTypeScannerDoor = TileEntityType.func_200966_a((String)"securitycraft:scanner_door", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityScannerDoor::new));
        SCContent.teTypeSecretSign = TileEntityType.func_200966_a((String)"securitycraft:secret_sign", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntitySecretSign::new));
        SCContent.teTypeMotionLight = TileEntityType.func_200966_a((String)"securitycraft:motion_light", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityMotionLight::new));
        SCContent.teTypeTrackMine = TileEntityType.func_200966_a((String)"securitycraft:track_mine", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityTrackMine::new));
        SCContent.teTypeTrophySystem = TileEntityType.func_200966_a((String)"securitycraft:trophy_system", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityTrophySystem::new));
        SCContent.teTypeBlockPocketManager = TileEntityType.func_200966_a((String)"securitycraft:block_pocket_manager", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityBlockPocketManager::new));
        SCContent.teTypeBlockPocket = TileEntityType.func_200966_a((String)"securitycraft:block_pocket", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityBlockPocket::new));
        SCContent.teTypeReinforcedPressurePlate = TileEntityType.func_200966_a((String)"securitycraft:reinforced_pressure_plate", (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityReinforcedPressurePlate::new));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        SCContent.eTypeBouncingBetty = EntityType.func_200712_a((String)"securitycraft:bouncingbetty", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityBouncingBetty.class, EntityBouncingBetty::new).tracker(128, 1, true));
        SCContent.eTypeTaserBullet = EntityType.func_200712_a((String)"securitycraft:taserbullet", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityTaserBullet.class, EntityTaserBullet::new).tracker(256, 1, true));
        SCContent.eTypeImsBomb = EntityType.func_200712_a((String)"securitycraft:imsbomb", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityIMSBomb.class, EntityIMSBomb::new).tracker(256, 1, true));
        SCContent.eTypeSecurityCamera = EntityType.func_200712_a((String)"securitycraft:securitycamera", (EntityType.Builder)EntityType.Builder.func_201757_a(EntitySecurityCamera.class, EntitySecurityCamera::new).tracker(256, 20, true));
        SCContent.eTypeSentry = EntityType.func_200712_a((String)"securitycraft:sentry", (EntityType.Builder)EntityType.Builder.func_201757_a(EntitySentry.class, EntitySentry::new).tracker(256, 1, true));
        SCContent.eTypeBullet = EntityType.func_200712_a((String)"securitycraft:bullet", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityBullet.class, EntityBullet::new).tracker(256, 1, true));
    }

    public static void registerPackets() {
        int index = 0;
        SecurityCraft.channel.registerMessage(index++, SetScanType.class, SetScanType::encode, SetScanType::decode, SetScanType::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetKeycardLevel.class, SetKeycardLevel::encode, SetKeycardLevel::decode, SetKeycardLevel::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateLogger.class, UpdateLogger::encode, UpdateLogger::decode, UpdateLogger::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateNBTTagOnClient.class, UpdateNBTTagOnClient::encode, UpdateNBTTagOnClient::decode, UpdateNBTTagOnClient::onMessage);
        SecurityCraft.channel.registerMessage(index++, PlaySoundAtPos.class, PlaySoundAtPos::encode, PlaySoundAtPos::decode, PlaySoundAtPos::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetExplosiveState.class, SetExplosiveState::encode, SetExplosiveState::decode, SetExplosiveState::onMessage);
        SecurityCraft.channel.registerMessage(index++, GivePotionEffect.class, GivePotionEffect::encode, GivePotionEffect::decode, GivePotionEffect::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetPassword.class, SetPassword::encode, SetPassword::decode, SetPassword::onMessage);
        SecurityCraft.channel.registerMessage(index++, CheckPassword.class, CheckPassword::encode, CheckPassword::decode, CheckPassword::onMessage);
        SecurityCraft.channel.registerMessage(index++, MountCamera.class, MountCamera::encode, MountCamera::decode, MountCamera::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetCameraRotation.class, SetCameraRotation::encode, SetCameraRotation::decode, SetCameraRotation::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetPlayerPositionAndRotation.class, SetPlayerPositionAndRotation::encode, SetPlayerPositionAndRotation::decode, SetPlayerPositionAndRotation::onMessage);
        SecurityCraft.channel.registerMessage(index++, OpenGui.class, OpenGui::encode, OpenGui::decode, OpenGui::onMessage);
        SecurityCraft.channel.registerMessage(index++, ToggleOption.class, ToggleOption::encode, ToggleOption::decode, ToggleOption::onMessage);
        SecurityCraft.channel.registerMessage(index++, RequestTEOwnableUpdate.class, RequestTEOwnableUpdate::encode, RequestTEOwnableUpdate::decode, RequestTEOwnableUpdate::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateTEOwnable.class, UpdateTEOwnable::encode, UpdateTEOwnable::decode, UpdateTEOwnable::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateSliderValue.class, UpdateSliderValue::encode, UpdateSliderValue::decode, UpdateSliderValue::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemoveCameraTag.class, RemoveCameraTag::encode, RemoveCameraTag::decode, RemoveCameraTag::onMessage);
        SecurityCraft.channel.registerMessage(index++, InitSentryAnimation.class, InitSentryAnimation::encode, InitSentryAnimation::decode, InitSentryAnimation::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetCameraPowered.class, SetCameraPowered::encode, SetCameraPowered::decode, SetCameraPowered::onMessage);
        SecurityCraft.channel.registerMessage(index++, CloseFurnace.class, CloseFurnace::encode, CloseFurnace::decode, CloseFurnace::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateNBTTagOnServer.class, UpdateNBTTagOnServer::encode, UpdateNBTTagOnServer::decode, UpdateNBTTagOnServer::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncTENBTTag.class, SyncTENBTTag::encode, SyncTENBTTag::decode, SyncTENBTTag::onMessage);
        SecurityCraft.channel.registerMessage(index++, ToggleBlockPocketManager.class, ToggleBlockPocketManager::encode, ToggleBlockPocketManager::decode, ToggleBlockPocketManager::onMessage);
        SecurityCraft.channel.registerMessage(index++, ClearLoggerServer.class, ClearLoggerServer::encode, ClearLoggerServer::decode, ClearLoggerServer::onMessage);
        SecurityCraft.channel.registerMessage(index++, ClearLoggerClient.class, ClearLoggerClient::encode, ClearLoggerClient::decode, ClearLoggerClient::onMessage);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (int i = 0; i < SCSounds.values().length; ++i) {
            event.getRegistry().register((IForgeRegistryEntry)SCSounds.values()[i].event);
        }
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, String designedBy) {
        RegistrationHandler.registerBlock(event, block, true, designedBy);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block) {
        RegistrationHandler.registerBlock(event, block, true, null);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, boolean initPage) {
        RegistrationHandler.registerBlock(event, block, initPage, null);
    }

    private static void registerBlock(RegistryEvent.Register<Block> event, Block block, boolean initPage, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)block);
        if (initPage) {
            blockPages.add(block);
        }
        if (designedBy != null) {
            blocksDesignedBy.put(block, designedBy);
        }
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item) {
        RegistrationHandler.registerItem(event, item, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, BooleanSupplier configValue) {
        RegistrationHandler.registerItem(event, item, configValue, "");
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)item);
        SCManualPage page = new SCManualPage(item, "help." + item.func_77658_a().substring(5) + ".info");
        page.setDesignedBy(designedBy);
        SecurityCraft.instance.manualPages.add(page);
    }

    private static void registerItem(RegistryEvent.Register<Item> event, Item item, BooleanSupplier configValue, String designedBy) {
        event.getRegistry().register((IForgeRegistryEntry)item);
        SCManualPage page = new SCManualPage(item, "help." + item.func_77658_a().substring(5) + ".info", configValue);
        page.setDesignedBy(designedBy);
        SecurityCraft.instance.manualPages.add(page);
    }
}

