/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.models.ModelDynamicBakedKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] facings = new String[]{"east", "north", "south", "west"};
        String[] bools = new String[]{"true", "false"};
        for (String facing : facings) {
            for (String bool : bools) {
                ModelResourceLocation mrl = new ModelResourceLocation("securitycraft:keypad", "facing=" + facing + ",powered=" + bool);
                event.getModelRegistry().put(mrl, new ModelDynamicBakedKeypad((IBakedModel)event.getModelRegistry().get(mrl)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c().equals((Object)event.getTarget().func_178782_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && BlockUtils.getBlock((World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v))) instanceof BlockSecurityCamera) {
                GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, Minecraft.func_71410_x().field_195558_d, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v)));
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            World world = player.func_130014_f_();
            int held = player.field_71071_by.field_70461_c;
            if (held < 0 || held >= player.field_71071_by.field_70462_a.size()) {
                return;
            }
            ItemStack monitor = (ItemStack)player.field_71071_by.field_70462_a.get(held);
            if (!monitor.func_190926_b() && monitor.func_77973_b() == SCContent.cameraMonitor) {
                String textureToUse = "camera_not_bound";
                double eyeHeight = player.func_70047_e();
                Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                RayTraceResult mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_178782_a()) instanceof TileEntitySecurityCamera) {
                    NBTTagCompound cameras = monitor.func_77978_p();
                    if (cameras != null) {
                        for (int i = 1; i < 31; ++i) {
                            String[] coords;
                            if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_178782_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_178782_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_178782_a().func_177952_p()) continue;
                            textureToUse = "camera_bound";
                            break;
                        }
                    }
                    GlStateManager.func_179141_d();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    SCClientEventHandler.drawNonStandardTexturedRect(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - 90 + held * 20 + 2, Minecraft.func_71410_x().field_195558_d.func_198087_p() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GlStateManager.func_179118_c();
                }
            }
        }
    }

    @SubscribeEvent
    public static void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntity())) {
            event.setNewfov(((EntitySecurityCamera)event.getEntity().func_184187_bx()).getZoomAmount());
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71441_e != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && event.getButton() != 1 && Minecraft.func_71410_x().field_71439_g.field_71070_bA != null && !(Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerGeneric) && !Minecraft.func_71410_x().func_147113_T()) {
            event.setCanceled(true);
        }
    }

    private static void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), z).func_187315_a((double)u * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)(u + width) * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, z).func_187315_a((double)(u + width) * widthFactor, (double)v * heightFactor).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, z).func_187315_a((double)u * widthFactor, (double)v * heightFactor).func_181675_d();
        tessellator.func_78381_a();
    }
}

