/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.commands.CommandSC;
import net.geforcemods.securitycraft.compat.top.TOPDataProvider;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.itemgroups.ItemGroupSCDecoration;
import net.geforcemods.securitycraft.itemgroups.ItemGroupSCExplosives;
import net.geforcemods.securitycraft.itemgroups.ItemGroupSCTechnical;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.KeycardConditions;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.network.ServerProxy;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="securitycraft")
@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    protected static final String VERSION = "v1.8.13";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());
    public static SecurityCraft instance;
    public static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;
    public HashMap<String, Object[]> cameraUsePositions = new HashMap();
    public ArrayList<SCManualPage> manualPages = new ArrayList();
    private NBTTagCompound savedModule;
    public static ItemGroup groupSCTechnical;
    public static ItemGroup groupSCMine;
    public static ItemGroup groupSCDecoration;

    public SecurityCraft() {
        instance = this;
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.CommonConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> GuiHandler::getClientGuiElement);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        SecurityCraft.log("Regisering mod content... (PT 1/2)");
        RegistrationHandler.registerPackets();
        KeycardConditions.registerAll();
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        proxy.clientSetup();
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        SecurityCraft.log("Setting up inter-mod stuff...");
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
        SecurityCraft.log("Registering mod content... (PT 2/2)");
        EnumCustomModules.refresh();
        proxy.getOrPopulateToTint().forEach((block, tint) -> Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> tint, new Block[]{block}));
        proxy.getOrPopulateToTint().forEach((item, tint) -> Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> tint, new IItemProvider[]{item}));
        proxy.cleanup();
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        DataSerializers.func_187189_a(Owner.SERIALIZER);
        for (Field field : SCContent.class.getFields()) {
            try {
                if (!field.isAnnotationPresent(Reinforced.class)) continue;
                IReinforcedBlock.BLOCKS.add((Block)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        SecurityCraft.log("Mod finished loading correctly! :D");
    }

    public void serverStarting(FMLServerStartingEvent event) {
        CommandSC.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public Object[] getUsePosition(String playerName) {
        return this.cameraUsePositions.get(playerName);
    }

    public void setUsePosition(String playerName, double x, double y, double z, float yaw, float pitch) {
        this.cameraUsePositions.put(playerName, new Object[]{x, y, z, Float.valueOf(yaw), Float.valueOf(pitch)});
    }

    public boolean hasUsePosition(String playerName) {
        return this.cameraUsePositions.containsKey(playerName);
    }

    public void removeUsePosition(String playerName) {
        this.cameraUsePositions.remove(playerName);
    }

    public NBTTagCompound getSavedModule() {
        return this.savedModule;
    }

    public void setSavedModule(NBTTagCompound savedModule) {
        this.savedModule = savedModule;
    }

    public static void log(String line) {
        SecurityCraft.log(line, false);
    }

    public static void log(String line, boolean isSevereError) {
    }

    public static String getVersion() {
        return VERSION;
    }

    static {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        groupSCTechnical = new ItemGroupSCTechnical();
        groupSCMine = new ItemGroupSCExplosives();
        groupSCDecoration = new ItemGroupSCDecoration();
    }
}

