/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class CustomizableSCTE
extends TileEntityOwnable
implements IInventory {
    private boolean linkable = false;
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private NBTTagList nbtTagStorage = null;
    public NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getNumberOfCustomizableOptions(), (Object)ItemStack.field_190927_a);
    public ItemStack[] itemStackss = new ItemStack[this.getNumberOfCustomizableOptions()];

    public CustomizableSCTE(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Modules", 10);
        this.modules = NonNullList.func_191197_a((int)this.getNumberOfCustomizableOptions(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("ModuleSlot");
            if (slot < 0 || slot >= this.modules.size()) continue;
            this.modules.set((int)slot, (Object)ItemStack.func_199557_a((NBTTagCompound)stackTag));
        }
        if (this.customOptions() != null) {
            for (Option<?> option : this.customOptions()) {
                option.readFromNBT(tag);
            }
        }
        if (tag.func_74764_b("linkable")) {
            this.linkable = tag.func_74767_n("linkable");
        }
        if (this.linkable && tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.modules.size(); ++i) {
            if (((ItemStack)this.modules.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("ModuleSlot", (byte)i);
            ((ItemStack)this.modules.get(i)).func_77955_b(stackTag);
            list.add((INBTBase)stackTag);
        }
        tag.func_74782_a("Modules", (INBTBase)list);
        if (this.customOptions() != null) {
            for (Option<?> option : this.customOptions()) {
                option.writeToNBT(tag);
            }
        }
        tag.func_74757_a("linkable", this.linkable);
        if (this.linkable && this.func_145830_o() && this.linkedBlocks.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            WorldUtils.addScheduledTask((IWorld)this.field_145850_b, () -> {
                for (LinkedBlock block : this.linkedBlocks) {
                    NBTTagCompound toAppend = new NBTTagCompound();
                    if (block != null) {
                        if (!block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(block);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.blockName);
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.add((INBTBase)toAppend);
                }
                tag.func_74782_a("linkedBlocks", (INBTBase)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(NBTTagList list) {
        if (!this.linkable) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, x, y, z);
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.func_197649_b(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            CustomizableSCTE.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    public int func_70302_i_() {
        return this.getNumberOfCustomizableOptions();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.modules.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.modules.get(index)).func_190926_b()) {
            if (((ItemStack)this.modules.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.modules.get(index);
                this.modules.set(index, (Object)ItemStack.field_190927_a);
                this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
                this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
                if (this instanceof TileEntitySecurityCamera) {
                    this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                }
                return stack;
            }
            ItemStack stack = ((ItemStack)this.modules.get(index)).func_77979_a(count);
            if (((ItemStack)this.modules.get(index)).func_190916_E() == 0) {
                this.modules.set(index, (Object)ItemStack.field_190927_a);
            }
            this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
            if (this instanceof TileEntitySecurityCamera) {
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack safeDecrStackSize(int index, int count) {
        if (!((ItemStack)this.modules.get(index)).func_190926_b()) {
            if (((ItemStack)this.modules.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.modules.get(index);
                this.modules.set(index, (Object)ItemStack.field_190927_a);
                this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
                this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
                if (this instanceof TileEntitySecurityCamera) {
                    this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                }
                return stack;
            }
            ItemStack stack = ((ItemStack)this.modules.get(index)).func_77979_a(count);
            if (((ItemStack)this.modules.get(index)).func_190916_E() == 0) {
                this.modules.set(index, (Object)ItemStack.field_190927_a);
            }
            this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
            if (this instanceof TileEntitySecurityCamera) {
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.modules.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.modules.get(index);
            this.modules.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.modules.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack = new ItemStack((IItemProvider)stack.func_77973_b(), this.func_70297_j_());
        }
        if (!stack.func_190926_b()) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModule());
            if (this instanceof TileEntitySecurityCamera) {
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
        }
    }

    public void safeSetInventorySlotContents(int index, ItemStack stack) {
        this.modules.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack = new ItemStack((IItemProvider)stack.func_77973_b(), this.func_70297_j_());
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemModule) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
            if (this instanceof TileEntitySecurityCamera) {
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177967_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString("Customize");
    }

    @Override
    public boolean hasCustomSCName() {
        return this.getCustomSCName() != null && !this.getCustomSCName().func_150254_d().equals("name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemModule;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.modules) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.modules.size(); ++i) {
            this.modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public void onTileEntityDestroyed() {
        if (this.linkable) {
            for (LinkedBlock block : this.linkedBlocks) {
                CustomizableSCTE.unlink(block.asTileEntity(this.field_145850_b), this);
            }
        }
        for (ItemStack module : this.modules) {
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)module);
        }
    }

    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
    }

    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
    }

    public ArrayList<EnumCustomModules> getModules() {
        ArrayList<EnumCustomModules> modules = new ArrayList<EnumCustomModules>();
        for (ItemStack stack : this.modules) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemModule)) continue;
            modules.add(((ItemModule)stack.func_77973_b()).getModule());
        }
        return modules;
    }

    public ItemStack getModule(EnumCustomModules module) {
        for (int i = 0; i < this.modules.size(); ++i) {
            if (((ItemStack)this.modules.get(i)).func_190926_b() || !(((ItemStack)this.modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)this.modules.get(i)).func_77973_b()).getModule() != module) continue;
            return (ItemStack)this.modules.get(i);
        }
        return ItemStack.field_190927_a;
    }

    public void insertModule(EnumCustomModules module) {
        int i;
        for (i = 0; i < this.modules.size(); ++i) {
            if (((ItemStack)this.modules.get(i)).func_190926_b() || ((ItemStack)this.modules.get(i)).func_77973_b() != module.getItem()) continue;
            return;
        }
        for (i = 0; i < this.modules.size(); ++i) {
            if (!((ItemStack)this.modules.get(i)).func_190926_b() && module != null) {
                this.modules.set(i, (Object)new ItemStack((IItemProvider)module.getItem()));
                break;
            }
            if (((ItemStack)this.modules.get(i)).func_190926_b() || module != null) continue;
            this.modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void insertModule(ItemStack module) {
        int i;
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        for (i = 0; i < this.modules.size(); ++i) {
            if (((ItemStack)this.modules.get(i)).func_190926_b() || ((ItemStack)this.modules.get(i)).func_77973_b() != module.func_77973_b()) continue;
            return;
        }
        for (i = 0; i < this.modules.size(); ++i) {
            if (!((ItemStack)this.modules.get(i)).func_190926_b()) continue;
            this.modules.set(i, (Object)module.func_77946_l());
            break;
        }
    }

    public void removeModule(EnumCustomModules module) {
        for (int i = 0; i < this.modules.size(); ++i) {
            if (((ItemStack)this.modules.get(i)).func_190926_b() || !(((ItemStack)this.modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)this.modules.get(i)).func_77973_b()).getModule() != module) continue;
            this.modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean hasModule(EnumCustomModules module) {
        if (module == null) {
            for (int i = 0; i < this.modules.size(); ++i) {
                if (!((ItemStack)this.modules.get(i)).func_190926_b()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.modules.size(); ++i) {
                if (((ItemStack)this.modules.get(i)).func_190926_b() || !(((ItemStack)this.modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)this.modules.get(i)).func_77973_b()).getModule() != module) continue;
                return true;
            }
        }
        return false;
    }

    public int getNumberOfCustomizableOptions() {
        return this.acceptedModules().length;
    }

    public ArrayList<EnumCustomModules> getAcceptedModules() {
        ArrayList<EnumCustomModules> list = new ArrayList<EnumCustomModules>();
        for (EnumCustomModules module : this.acceptedModules()) {
            list.add(module);
        }
        return list;
    }

    public Option<?> getOptionByName(String name) {
        for (Option<?> option : this.customOptions()) {
            if (!option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public CustomizableSCTE linkable() {
        this.linkable = true;
        return this;
    }

    public boolean canBeLinkedWith() {
        return this.linkable;
    }

    public static void link(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        if (CustomizableSCTE.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return false;
        }
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, CustomizableSCTE excludedTE) {
        ArrayList<CustomizableSCTE> list = new ArrayList<CustomizableSCTE>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (!this.linkable) {
            return;
        }
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.field_145850_b).sync();
        }
    }

    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
    }

    public abstract EnumCustomModules[] acceptedModules();

    public abstract Option<?>[] customOptions();
}

