/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TileEntitySCTE
extends TileEntity
implements ITickable,
INameable {
    protected boolean intersectsEntities = false;
    protected boolean viewActivated = false;
    private boolean attacks = false;
    private boolean canBeNamed = false;
    private ITextComponent customName = new TextComponentString("name");
    private double attackRange = 0.0;
    private int blockPlaceCooldown = 30;
    private int viewCooldown = this.getViewCooldown();
    private int ticksBetweenAttacks = 0;
    private int attackCooldown = 0;
    private Class<? extends Entity> typeToAttack = Entity.class;

    public TileEntitySCTE() {
        this(SCContent.teTypeAbstract);
    }

    public TileEntitySCTE(TileEntityType<?> type) {
        super(type);
    }

    public void func_73660_a() {
        List entities;
        AxisAlignedBB area;
        int z;
        int y;
        int x;
        if (this.intersectsEntities) {
            x = this.field_174879_c.func_177958_n();
            y = this.field_174879_c.func_177956_o();
            z = this.field_174879_c.func_177952_p();
            area = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            entities = this.field_145850_b.func_72872_a(Entity.class, area);
            for (Entity entity : entities) {
                this.entitytersecting(entity);
            }
        }
        if (this.viewActivated) {
            if (this.blockPlaceCooldown > 0) {
                --this.blockPlaceCooldown;
                return;
            }
            if (this.viewCooldown > 0) {
                --this.viewCooldown;
                return;
            }
            x = this.field_174879_c.func_177958_n();
            y = this.field_174879_c.func_177956_o();
            z = this.field_174879_c.func_177952_p();
            area = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(5.0, 5.0, 5.0);
            entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, area);
            for (Entity entity : entities) {
                double eyeHeight = entity.func_70047_e();
                boolean isPlayer = entity instanceof EntityPlayer;
                Vec3d lookVec = new Vec3d(entity.field_70165_t + entity.func_70040_Z().field_72450_a * 5.0, eyeHeight + entity.field_70163_u + entity.func_70040_Z().field_72448_b * 5.0, entity.field_70161_v + entity.func_70040_Z().field_72449_c * 5.0);
                RayTraceResult mop = this.func_145831_w().func_72933_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), lookVec);
                if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK || mop.func_178782_a().func_177958_n() != this.func_174877_v().func_177958_n() || mop.func_178782_a().func_177956_o() != this.func_174877_v().func_177956_o() || mop.func_178782_a().func_177952_p() != this.func_174877_v().func_177952_p() || (!isPlayer || !this.activatedOnlyByPlayer()) && this.activatedOnlyByPlayer()) continue;
                this.entityViewed((EntityLivingBase)entity);
                this.viewCooldown = this.getViewCooldown();
            }
        }
        if (this.attacks) {
            if (this.attackCooldown < this.getTicksBetweenAttacks()) {
                ++this.attackCooldown;
                return;
            }
            if (this.canAttack()) {
                AxisAlignedBB area2 = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
                List entities2 = this.field_145850_b.func_72872_a(this.entityTypeToAttack(), area2);
                Iterator iterator = entities2.iterator();
                if (!this.field_145850_b.field_72995_K) {
                    boolean attacked = false;
                    if (!iterator.hasNext()) {
                        this.attackFailed();
                    }
                    while (iterator.hasNext()) {
                        Entity mobToAttack = (Entity)iterator.next();
                        if (mobToAttack == null || mobToAttack instanceof EntityItem || !this.shouldAttackEntityType(mobToAttack) || !this.attackEntity(mobToAttack)) continue;
                        attacked = true;
                    }
                    if (attacked || this.shouldRefreshAttackCooldown()) {
                        this.attackCooldown = 0;
                    }
                    if (attacked || this.shouldSyncToClient()) {
                        this.sync();
                    }
                }
            }
        }
    }

    public void entitytersecting(Entity entity) {
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof IIntersectable)) {
            return;
        }
        ((IIntersectable)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()).onEntityIntersected(this.func_145831_w(), this.func_174877_v(), entity);
    }

    public void entityViewed(EntityLivingBase entity) {
    }

    public boolean attackEntity(Entity entity) {
        return false;
    }

    public void attackFailed() {
    }

    public boolean canAttack() {
        return false;
    }

    public boolean shouldAttackEntityType(Entity entity) {
        return entity instanceof EntityPlayer || this.typeToAttack.isAssignableFrom(entity.getClass());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("intersectsEntities", this.intersectsEntities);
        tag.func_74757_a("viewActivated", this.viewActivated);
        tag.func_74757_a("attacks", this.attacks);
        tag.func_74757_a("canBeNamed", this.canBeNamed);
        tag.func_74780_a("attackRange", this.attackRange);
        tag.func_74768_a("attackCooldown", this.attackCooldown);
        tag.func_74768_a("ticksBetweenAttacks", this.ticksBetweenAttacks);
        tag.func_74778_a("customName", this.customName.func_150254_d());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("intersectsEntities")) {
            this.intersectsEntities = tag.func_74767_n("intersectsEntities");
        }
        if (tag.func_74764_b("viewActivated")) {
            this.viewActivated = tag.func_74767_n("viewActivated");
        }
        if (tag.func_74764_b("attacks")) {
            this.attacks = tag.func_74767_n("attacks");
        }
        if (tag.func_74764_b("canBeNamed")) {
            this.canBeNamed = tag.func_74767_n("canBeNamed");
        }
        if (tag.func_74764_b("attackRange")) {
            this.attackRange = tag.func_74769_h("attackRange");
        }
        if (tag.func_74764_b("attackCooldown")) {
            this.attackCooldown = tag.func_74762_e("attackCooldown");
        }
        if (tag.func_74764_b("ticksBetweenAttacks")) {
            this.ticksBetweenAttacks = tag.func_74762_e("ticksBetweenAttacks");
        }
        if (tag.func_74764_b("customName")) {
            this.customName = new TextComponentString(tag.func_74779_i("customName"));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return super.shouldRenderInPass(pass);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onTileEntityDestroyed();
    }

    public void onTileEntityDestroyed() {
    }

    public void sync() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            ClientUtils.syncTileEntity(this);
        } else {
            ServerLifecycleHooks.getCurrentServer().func_184103_al().func_148540_a((Packet)this.func_189518_D_());
        }
    }

    public TileEntitySCTE intersectsEntities() {
        this.intersectsEntities = true;
        return this;
    }

    public boolean doesIntersectsEntities() {
        return this.intersectsEntities;
    }

    public TileEntitySCTE activatedByView() {
        this.viewActivated = true;
        return this;
    }

    public int getViewCooldown() {
        return 0;
    }

    public boolean activatedOnlyByPlayer() {
        return true;
    }

    public boolean isActivatedByView() {
        return this.viewActivated;
    }

    public TileEntitySCTE attacks(Class<? extends Entity> type, double range, int cooldown) {
        this.attacks = true;
        this.typeToAttack = type;
        this.attackRange = range;
        this.ticksBetweenAttacks = cooldown;
        return this;
    }

    public Class<? extends Entity> entityTypeToAttack() {
        return this.typeToAttack;
    }

    public double getAttackRange() {
        return this.attackRange;
    }

    public int getTicksBetweenAttacks() {
        return this.ticksBetweenAttacks;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public void attackNextTick() {
        this.attackCooldown = this.ticksBetweenAttacks;
    }

    public boolean shouldRefreshAttackCooldown() {
        return true;
    }

    public boolean shouldSyncToClient() {
        return true;
    }

    public boolean doesAttack() {
        return this.attacks;
    }

    public TileEntitySCTE nameable() {
        this.canBeNamed = true;
        return this;
    }

    @Override
    public ITextComponent getCustomSCName() {
        return this.customName;
    }

    @Override
    public void setCustomSCName(ITextComponent customName) {
        this.customName = customName;
        this.sync();
    }

    @Override
    public boolean hasCustomSCName() {
        return this.customName != null && !this.customName.func_150254_d().equals("name");
    }

    @Override
    public boolean canBeNamed() {
        return this.canBeNamed;
    }
}

