/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityAlarm;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockAlarm
extends BlockOwnable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    private static final VoxelShape SHAPE_UP = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockAlarm() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(-1.0f, 6000000.0f).func_200944_c());
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.UP)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing == EnumFacing.UP && world.func_180495_p(pos.func_177977_b()).func_185896_q() ? true : BlockUtils.isSideSolid(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_196260_a(state, (IWorldReaderBase)world, pos)) {
            this.func_196255_a(state, world, pos, 1.0f, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177972_a(facing.func_176734_d()), facing) ? (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing) : null;
    }

    public void func_196259_b(IBlockState state, World world, BlockPos pos, IBlockState oldState) {
        if (world.field_72995_K) {
            return;
        }
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            this.playSoundAndUpdate(world, pos);
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 5);
        }
    }

    public void onNeighborChange(IBlockState state, IWorldReader w, BlockPos pos, BlockPos neighbor) {
        if (w.func_201670_d() || !(w instanceof World)) {
            return;
        }
        World world = (World)w;
        this.playSoundAndUpdate(world, pos);
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (!BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            this.func_196255_a(world.func_180495_p(pos), world, pos, 1.0f, 0);
            world.func_175698_g(pos);
        }
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    private void playSoundAndUpdate(World world, BlockPos pos) {
        if (!(world.func_175625_s(pos) instanceof TileEntityAlarm)) {
            return;
        }
        if (world.func_175687_A(pos) > 0) {
            boolean isPowered = ((TileEntityAlarm)world.func_175625_s(pos)).isPowered();
            if (!isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_175625_s(pos)).getOwner();
                BlockUtils.setBlockProperty(world, pos, LIT, true);
                ((TileEntityAlarm)world.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_175625_s(pos)).setPowered(true);
            }
        } else {
            boolean isPowered = ((TileEntityAlarm)world.func_175625_s(pos)).isPowered();
            if (isPowered) {
                Owner owner = ((TileEntityAlarm)world.func_175625_s(pos)).getOwner();
                BlockUtils.setBlockProperty(world, pos, LIT, false);
                ((TileEntityAlarm)world.func_175625_s(pos)).getOwner().set(owner);
                ((TileEntityAlarm)world.func_175625_s(pos)).setPowered(false);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)SCContent.alarm.func_199767_j());
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return SCContent.alarm.func_199767_j();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{LIT});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityAlarm();
    }
}

