/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityCageTrap;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockCageTrap
extends BlockOwnable
implements IIntersectable {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");

    public BlockCageTrap(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f).func_200942_a());
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DEACTIVATED) != false ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            TileEntityCageTrap tileEntity = (TileEntityCageTrap)world.func_175625_s(pos);
            boolean isPlayer = entity instanceof EntityPlayer;
            boolean shouldCaptureMobs = tileEntity.getOptionByName("captureMobs").asBoolean();
            if (isPlayer || entity instanceof EntityMob && shouldCaptureMobs) {
                if (isPlayer && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)entity)) {
                    return;
                }
                if (BlockUtils.getBlockPropertyAsBoolean(world, pos, DEACTIVATED)) {
                    return;
                }
                BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
                BlockUtils.setBlock(world, pos.func_177981_b(4), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n() + 1, pos.func_177956_o() + 4, pos.func_177952_p(), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n() - 1, pos.func_177956_o() + 4, pos.func_177952_p(), SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n(), pos.func_177956_o() + 4, pos.func_177952_p() + 1, SCContent.reinforcedIronBars);
                BlockUtils.setBlock(world, pos.func_177958_n(), pos.func_177956_o() + 4, pos.func_177952_p() - 1, SCContent.reinforcedIronBars);
                BlockUtils.setBlockInBox(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), SCContent.reinforcedIronBars);
                this.setTileEntities(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ((IOwnable)world.func_175625_s(pos)).getOwner().getUUID(), ((IOwnable)world.func_175625_s(pos)).getOwner().getName());
                world.func_184133_a(null, pos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 3.0f, 1.0f);
                if (isPlayer) {
                    entity.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.BLACK + ClientUtils.localize(SCContent.cageTrap.func_149739_a(), new Object[0]) + TextFormatting.RESET + "] " + ClientUtils.localize("messages.securitycraft:cageTrap.captured", new Object[0]).replace("#player", ((EntityPlayer)entity).func_200200_C_().func_150254_d()).replace("#location", Utils.getFormattedCoordinates(pos)), new Object[0]));
                }
            }
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{DEACTIVATED});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityCageTrap().intersectsEntities();
    }

    public void setTileEntities(World world, int x, int y, int z, String uuid, String name) {
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 4, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 1, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 2, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 3, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 1, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 2, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 3, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x + 1, y + 4, z - 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z + 1))).getOwner().set(uuid, name);
        ((IOwnable)world.func_175625_s(BlockUtils.toPos(x - 1, y + 4, z - 1))).getOwner().set(uuid, name);
    }
}

