/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockFrame
extends BlockOwnable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0);

    public BlockFrame(Material material) {
        super(SoundType.field_185851_d, Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        VoxelShape shape = null;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                shape = SHAPE_NORTH;
                break;
            }
            case EAST: {
                shape = SHAPE_EAST;
                break;
            }
            case SOUTH: {
                shape = SHAPE_SOUTH;
                break;
            }
            case WEST: {
                shape = SHAPE_WEST;
                break;
            }
            default: {
                shape = VoxelShapes.func_197880_a();
            }
        }
        return VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b((IProperty)FACING) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }
}

