/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScannerField;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.TEInteractionObject;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockInventoryScanner
extends BlockContainer {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BlockInventoryScanner(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_196259_b(IBlockState state, World world, BlockPos pos, IBlockState oldState) {
        super.func_196259_b(state, world, pos, oldState);
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState north = world.func_180495_p(pos.func_177978_c());
            IBlockState south = world.func_180495_p(pos.func_177968_d());
            IBlockState west = world.func_180495_p(pos.func_177976_e());
            IBlockState east = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && north.func_185917_h() && !south.func_185917_h()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && south.func_185917_h() && !north.func_185917_h()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && west.func_185917_h() && !east.func_185917_h()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && east.func_185917_h() && !west.func_185917_h()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (this.isFacingAnotherScanner(world, pos) && player instanceof EntityPlayerMP) {
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new TEInteractionObject(GuiHandler.INVENTORY_SCANNER, world, pos), (BlockPos)pos);
        } else {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.inventoryScanner.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), TextFormatting.RED);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)entity));
        }
        if (world.field_72995_K) {
            return;
        }
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185917_h() && !south.func_185917_h()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185917_h() && !north.func_185917_h()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185917_h() && !east.func_185917_h()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185917_h() && !west.func_185917_h()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing), 2);
        this.checkAndPlaceAppropriately(world, pos);
    }

    private void checkAndPlaceAppropriately(World world, BlockPos pos) {
        int i;
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
        if (connectedScanner == null) {
            return;
        }
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        int loopBoundary = facing == EnumFacing.WEST || facing == EnumFacing.EAST ? Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()) : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()) : 0);
        for (i = 1; i < loopBoundary; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.inventoryScannerField) continue;
            return;
        }
        for (i = 1; i < loopBoundary; ++i) {
            world.func_175656_a(pos.func_177967_a(facing, i), (IBlockState)SCContent.inventoryScannerField.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing));
        }
        CustomizableSCTE.link((CustomizableSCTE)world.func_175625_s(pos), connectedScanner);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityInventoryScanner connectedScanner = null;
        block0: for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            for (int i = 1; i <= (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
                BlockPos offsetIPos = pos.func_177967_a(facing, i);
                if (BlockUtils.getBlock(world, offsetIPos) != SCContent.inventoryScanner) continue;
                for (int j = 1; j < i; ++j) {
                    BlockPos offsetJPos = pos.func_177967_a(facing, j);
                    IBlockState field = world.func_180495_p(offsetJPos);
                    if (field.func_177230_c() != SCContent.inventoryScannerField) continue;
                    if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
                        if (field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.WEST && field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.EAST) continue;
                        world.func_175655_b(offsetJPos, false);
                        continue;
                    }
                    if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH || field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.NORTH && field.func_177229_b((IProperty)BlockInventoryScannerField.FACING) != EnumFacing.SOUTH) continue;
                    world.func_175655_b(offsetJPos, false);
                }
                connectedScanner = (TileEntityInventoryScanner)world.func_175625_s(offsetIPos);
                continue block0;
            }
        }
        if (connectedScanner != null) {
            for (int i = 0; i < connectedScanner.getContents().size(); ++i) {
                connectedScanner.getContents().set(i, (Object)ItemStack.field_190927_a);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private boolean isFacingAnotherScanner(World world, BlockPos pos) {
        return BlockInventoryScanner.getConnectedInventoryScanner(world, pos) != null;
    }

    public static TileEntityInventoryScanner getConnectedInventoryScanner(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        for (int i = 0; i <= (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            IBlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            if (!state.isAir((IBlockReader)world, offsetPos) && block != SCContent.inventoryScannerField && block != SCContent.inventoryScanner) {
                return null;
            }
            if (block != SCContent.inventoryScanner || state.func_177229_b((IProperty)FACING) != facing.func_176734_d()) continue;
            return (TileEntityInventoryScanner)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (!(blockAccess.func_175625_s(pos) instanceof TileEntityInventoryScanner) || ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getScanType() == null) {
            SecurityCraft.log("type is null on the " + EffectiveSide.get() + " side");
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getScanType().equals("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getScanType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).getScanType().equals("redstone") && ((TileEntityInventoryScanner)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityInventoryScanner();
    }
}

