/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class BlockInventoryScannerField
extends BlockContainer
implements IIntersectable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public BlockInventoryScannerField(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        block6: {
            TileEntityInventoryScanner connectedScanner;
            block5: {
                connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(world, pos);
                if (connectedScanner == null) {
                    return;
                }
                if (!(entity instanceof EntityPlayer)) break block5;
                if (ModuleUtils.checkForModule(world, connectedScanner.func_174877_v(), (EntityPlayer)entity, EnumCustomModules.WHITELIST)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < ((EntityPlayer)entity).field_71071_by.field_70462_a.size(); ++j) {
                        if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((ItemStack)((EntityPlayer)entity).field_71071_by.field_70462_a.get(j)).func_190926_b()) continue;
                        BlockInventoryScannerField.checkInventory((EntityPlayer)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
                    }
                }
                break block6;
            }
            if (!(entity instanceof EntityItem)) break block6;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((EntityItem)entity).func_92059_d().func_190926_b()) continue;
                BlockInventoryScannerField.checkEntityItem((EntityItem)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
            }
        }
    }

    public static void checkInventory(EntityPlayer entity, TileEntityInventoryScanner te, ItemStack stack) {
        block4: {
            boolean hasStorageModule;
            boolean hasSmartModule;
            block3: {
                hasSmartModule = te.hasModule(EnumCustomModules.SMART);
                hasStorageModule = te.hasModule(EnumCustomModules.STORAGE);
                if (!te.getScanType().equals("redstone")) break block3;
                for (int i = 1; i <= entity.field_71071_by.field_70462_a.size(); ++i) {
                    ItemStack itemStackChecking = (ItemStack)entity.field_71071_by.field_70462_a.get(i - 1);
                    if (itemStackChecking.func_190926_b() || !(hasSmartModule && BlockInventoryScannerField.areItemStacksEqual(itemStackChecking, stack) && ItemStack.func_77970_a((ItemStack)itemStackChecking, (ItemStack)stack) || !hasSmartModule && itemStackChecking.func_77973_b() == stack.func_77973_b()) && !BlockInventoryScannerField.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule)) continue;
                    BlockInventoryScannerField.updateInventoryScannerPower(te);
                }
                break block4;
            }
            if (!te.getScanType().equals("check")) break block4;
            for (int i = 1; i <= entity.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack itemStackChecking = (ItemStack)entity.field_71071_by.field_70462_a.get(i - 1);
                if (itemStackChecking.func_190926_b()) continue;
                BlockInventoryScannerField.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule);
                if ((!hasSmartModule || !BlockInventoryScannerField.areItemStacksEqual(itemStackChecking, stack) || !ItemStack.func_77970_a((ItemStack)itemStackChecking, (ItemStack)stack)) && (hasSmartModule || itemStackChecking.func_77973_b() != stack.func_77973_b())) continue;
                if (hasStorageModule) {
                    te.addItemToStorage(itemStackChecking);
                }
                entity.field_71071_by.field_70462_a.set(i - 1, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static void checkEntityItem(EntityItem entity, TileEntityInventoryScanner te, ItemStack stack) {
        boolean hasSmartModule = te.hasModule(EnumCustomModules.SMART);
        boolean hasStorageModule = te.hasModule(EnumCustomModules.STORAGE);
        if (te.getScanType().equals("redstone")) {
            if (hasSmartModule && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !hasSmartModule && entity.func_92059_d().func_77973_b() == stack.func_77973_b() || BlockInventoryScannerField.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule)) {
                BlockInventoryScannerField.updateInventoryScannerPower(te);
            }
        } else if (te.getScanType().equals("check")) {
            BlockInventoryScannerField.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule);
            if (hasSmartModule && BlockInventoryScannerField.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !hasSmartModule && entity.func_92059_d().func_77973_b() == stack.func_77973_b()) {
                if (hasStorageModule) {
                    te.addItemToStorage(entity.func_92059_d());
                }
                entity.func_70106_y();
            }
        }
    }

    private static boolean checkForShulkerBox(ItemStack item, ItemStack stackToCheck, TileEntityInventoryScanner te, boolean hasSmartModule, boolean hasStorageModule) {
        boolean deletedItem = false;
        if (item != null && !item.func_190926_b() && item.func_77978_p() != null && Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockShulkerBox) {
            NBTTagList list = item.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = ItemStack.func_199557_a((NBTTagCompound)list.func_150305_b(i));
                if ((!hasSmartModule || !BlockInventoryScannerField.areItemStacksEqual(itemInChest, stackToCheck) || !ItemStack.func_77970_a((ItemStack)itemInChest, (ItemStack)stackToCheck)) && (hasSmartModule || !BlockInventoryScannerField.areItemStacksEqual(itemInChest, stackToCheck))) continue;
                list.remove(i);
                deletedItem = true;
                if (!hasStorageModule) continue;
                te.addItemToStorage(itemInChest);
            }
        }
        return deletedItem;
    }

    private static void updateInventoryScannerPower(TileEntityInventoryScanner te) {
        if (!te.shouldProvidePower()) {
            te.setShouldProvidePower(true);
        }
        SecurityCraft.log("Running te update");
        te.setCooldown(60);
        BlockInventoryScannerField.checkAndUpdateTEAppropriately(te);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c(), 1, true);
        SecurityCraft.log("Emitting redstone on the " + (te.func_145831_w().field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER) + " side. (te coords: " + Utils.getFormattedCoordinates(te.func_174877_v()));
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.func_190920_e(1);
        s2.func_190920_e(1);
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    private static void checkAndUpdateTEAppropriately(TileEntityInventoryScanner te) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        if (connectedScanner == null) {
            return;
        }
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_195044_w().func_177230_c(), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.func_174877_v(), connectedScanner.func_195044_w().func_177230_c(), 1, true);
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (!world.func_201670_d()) {
            int j;
            int i;
            for (i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
                if (BlockUtils.getBlock((IBlockReader)world, pos.func_177985_f(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177985_f(j), false);
                }
                break;
            }
            for (i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
                if (BlockUtils.getBlock((IBlockReader)world, pos.func_177965_g(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177965_g(j), false);
                }
                break;
            }
            for (i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
                if (BlockUtils.getBlock((IBlockReader)world, pos.func_177964_d(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177964_d(j), false);
                }
                break;
            }
            for (i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.inventoryScannerRange.get(); ++i) {
                if (BlockUtils.getBlock((IBlockReader)world, pos.func_177970_e(i)) != SCContent.inventoryScanner) continue;
                for (j = 1; j < i; ++j) {
                    world.func_175655_b(pos.func_177970_e(j), false);
                }
                break;
            }
        }
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)source.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            return SHAPE_EW;
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            return SHAPE_NS;
        }
        return VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntitySCTE().intersectsEntities();
    }
}

