/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Map;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedFenceGate;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockIronFence
extends Block
implements IIntersectable {
    public static final BooleanProperty NORTH = BlockSixWay.field_196488_a;
    public static final BooleanProperty EAST = BlockSixWay.field_196490_b;
    public static final BooleanProperty SOUTH = BlockSixWay.field_196492_c;
    public static final BooleanProperty WEST = BlockSixWay.field_196495_y;
    protected static final Map<EnumFacing, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)BlockSixWay.field_196491_B.entrySet().stream().filter(p_199775_0_ -> ((EnumFacing)p_199775_0_.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    private final VoxelShape[] renderShapes;

    public BlockIronFence(Material material) {
        super(Block.Properties.func_200949_a((Material)material, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.renderShapes = this.func_196408_a(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
        this.collisionShapes = this.func_196408_a(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.func_196408_a(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196247_c(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.renderShapes[this.getIndex(state)];
    }

    protected VoxelShape[] func_196408_a(float p_196408_1_, float p_196408_2_, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - p_196408_1_;
        float f1 = 8.0f + p_196408_1_;
        float f2 = 8.0f - p_196408_2_;
        float f3 = 8.0f + p_196408_2_;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] returnValue = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            returnValue[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)returnValue[i]);
        }
        return returnValue;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.collisionShapes[this.getIndex(state)];
    }

    private static int getMask(EnumFacing facing) {
        return 1 << facing.func_176736_b();
    }

    protected int getIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= BlockIronFence.getMask(EnumFacing.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= BlockIronFence.getMask(EnumFacing.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= BlockIronFence.getMask(EnumFacing.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= BlockIronFence.getMask(EnumFacing.WEST);
        }
        return i;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)super.func_196258_a(ctx).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo((IBlockReader)world, pos, EnumFacing.NORTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo((IBlockReader)world, pos, EnumFacing.EAST)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo((IBlockReader)world, pos, EnumFacing.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo((IBlockReader)world, pos, EnumFacing.WEST)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176716_d() == EnumFacing.Plane.HORIZONTAL ? (IBlockState)state.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canFenceConnectTo((IBlockReader)world, currentPos, facing))) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(facing));
        return this.attachesTo(other, other.func_193401_d(world, pos.func_177972_a(facing), facing.func_176734_d()));
    }

    public boolean attachesTo(IBlockState state, BlockFaceShape faceShape) {
        Block block = state.func_177230_c();
        boolean flag = faceShape == BlockFaceShape.MIDDLE_POLE && (state.func_185904_a() == this.field_149764_J || block instanceof BlockReinforcedFenceGate);
        return !BlockIronFence.func_193382_c((Block)block) && faceShape == BlockFaceShape.SOLID || flag;
    }

    private boolean canFenceConnectTo(IBlockReader world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState other = world.func_180495_p(offset);
        return other.canBeConnectedTo(world, offset, facing.func_176734_d()) || this.func_176223_P().canBeConnectedTo(world, pos, facing);
    }

    public static boolean isExcepBlockForAttachWithPiston(Block block) {
        return Block.func_193382_c((Block)block) || block == Blocks.field_180401_cv || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_196625_cS || block == Blocks.field_196628_cT || block == Blocks.field_185778_de || block == Blocks.field_150335_W;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            if (((TileEntityOwnable)world.func_175625_s(pos)).getOwner().isOwner((EntityPlayer)entity)) {
                return;
            }
        } else if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
            creeper.func_70077_a(lightning);
            creeper.func_70066_B();
            return;
        }
        entity.func_70097_a((DamageSource)CustomDamageSources.electricity, 6.0f);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            world.func_175713_t(pos);
        }
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable().intersectsEntities();
    }
}

