/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.items.ItemKeycardBase;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockKeycardReader
extends BlockOwnable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public BlockKeycardReader(Material material) {
        super(SoundType.field_185852_e, Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185917_h() && !south.func_185917_h()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185917_h() && !north.func_185917_h()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185917_h() && !east.func_185917_h()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185917_h() && !west.func_185917_h()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public void insertCard(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        if (ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.BLACKLIST)) {
            return;
        }
        int requiredLevel = -1;
        int cardLvl = ((ItemKeycardBase)stack.func_77973_b()).getKeycardLvl(stack);
        if (((TileEntityKeycardReader)world.func_175625_s(pos)).getPassword() != null) {
            requiredLevel = Integer.parseInt(((TileEntityKeycardReader)world.func_175625_s(pos)).getPassword());
        }
        if (!((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel <= cardLvl || ((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel == cardLvl) {
            if (cardLvl == 6 && stack.func_77978_p() != null && !player.func_184812_l_()) {
                stack.func_77978_p().func_74768_a("Uses", stack.func_77978_p().func_74762_e("Uses") - 1);
                if (stack.func_77978_p().func_74762_e("Uses") <= 0) {
                    stack.func_190918_g(1);
                }
            }
            BlockKeycardReader.activate(world, pos);
        }
        if (world.field_72995_K) {
            if (requiredLevel != -1 && ((TileEntityKeycardReader)world.func_175625_s(pos)).doesRequireExactKeycard() && requiredLevel != cardLvl) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.keycardReader.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:keycardReader.required", new Object[0]).replace("#r", ((IPasswordProtected)world.func_175625_s(pos)).getPassword()).replace("#c", "" + ((ItemKeycardBase)stack.func_77973_b()).getKeycardLvl(stack)), TextFormatting.RED);
            } else if (requiredLevel == -1) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.keycardReader.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:keycardReader.notSet", new Object[0]), TextFormatting.RED);
            }
        }
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.field_71071_by.func_70448_g().func_190926_b() || !(player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemKeycardBase) && player.field_71071_by.func_70448_g().func_77973_b() != SCContent.adminTool) {
            ((TileEntityKeycardReader)world.func_175625_s(pos)).openPasswordGUI(player);
        } else if (player.field_71071_by.func_70448_g().func_77973_b() == SCContent.adminTool) {
            ((BlockKeycardReader)BlockUtils.getBlock(world, pos)).insertCard(world, pos, new ItemStack((IItemProvider)SCContent.limitedUseKeycard, 1), player);
        } else {
            ((BlockKeycardReader)BlockUtils.getBlock(world, pos)).insertCard(world, pos, player.field_71071_by.func_70448_g(), player);
        }
        return true;
    }

    public static void activate(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, POWERED, true);
        world.func_195593_d(pos, SCContent.keycardReader);
        world.func_205220_G_().func_205360_a(pos, (Object)SCContent.keycardReader, 60);
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, POWERED, false);
            world.func_195593_d(pos, SCContent.keycardReader);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityKeycardReader();
    }
}

