/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockFrame;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockKeypad
extends BlockContainer
implements IOverlayDisplay,
IPasswordConvertible {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public BlockKeypad(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200947_a(SoundType.field_185851_d).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        IBlockState extendedState = this.getExtendedState(state, world, pos);
        if (extendedState.func_177230_c() != this) {
            return extendedState.func_196954_c(world, pos);
        }
        return super.func_196244_b(state, world, pos);
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        IBlockState extendedState = this.getExtendedState(state, world, pos);
        if (extendedState.func_177230_c() != this) {
            return extendedState.func_196952_d(world, pos);
        }
        return super.func_196268_f(state, world, pos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityKeypad && ((TileEntityKeypad)te).hasModule(EnumCustomModules.DISGUISE)) {
            ItemStack module = ((TileEntityKeypad)te).getModule(EnumCustomModules.DISGUISE);
            if (((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                return BlockFaceShape.SOLID;
            }
            return ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).func_176223_P().func_193401_d(world, pos, face);
        }
        return BlockFaceShape.SOLID;
    }

    public boolean shouldSideBeRendered(IBlockReader world, BlockPos pos, EnumFacing side) {
        Block blockToDisguiseAs;
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        if (world.func_175625_s(pos) == null) {
            return true;
        }
        CustomizableSCTE tileEntity = (CustomizableSCTE)world.func_175625_s(pos);
        if (!(!tileEntity.hasModule(EnumCustomModules.DISGUISE) || (blocks = ((ItemModule)(disguiseModule = tileEntity.getModule(EnumCustomModules.DISGUISE)).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() == 0 || (blockToDisguiseAs = (Block)blocks.get(0)).func_176223_P().func_196954_c(world, pos).equals(VoxelShapes.func_197868_b()) && blockToDisguiseAs.func_176223_P().func_185917_h())) {
            return this.checkForSideTransparency(world, pos, world.func_180495_p(pos.func_177972_a(side)), side);
        }
        return true;
    }

    public boolean checkForSideTransparency(IBlockReader world, BlockPos keypadPos, IBlockState neighborState, EnumFacing side) {
        if (neighborState.isAir(world, keypadPos.func_177972_a(side))) {
            return true;
        }
        Block neighborBlock = neighborState.func_177230_c();
        return !(neighborBlock instanceof BlockBreakable) || !neighborBlock.getRegistryName().func_110624_b().equals("minecraft");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return false;
        }
        if (ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.WHITELIST) || ModuleUtils.checkForModule(world, pos, player, EnumCustomModules.BLACKLIST)) {
            BlockKeypad.activate(world, pos);
            return true;
        }
        if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker) && !PlayerUtils.isHoldingItem(player, SCContent.keyPanel)) {
            ((IPasswordProtected)world.func_175625_s(pos)).openPasswordGUI(player);
        }
        return true;
    }

    public static void activate(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, POWERED, true);
        world.func_195593_d(pos, SCContent.keypad);
        world.func_205220_G_().func_205360_a(pos, (Object)SCContent.keypad, 60);
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        BlockUtils.setBlockProperty(world, pos, POWERED, false);
        world.func_195593_d(pos, SCContent.keypad);
    }

    public void func_196259_b(IBlockState state, World world, BlockPos pos, IBlockState oldState) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        IBlockState north = world.func_180495_p(pos.func_177978_c());
        IBlockState south = world.func_180495_p(pos.func_177968_d());
        IBlockState west = world.func_180495_p(pos.func_177976_e());
        IBlockState east = world.func_180495_p(pos.func_177974_f());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH && north.func_185917_h() && !south.func_185917_h()) {
            facing = EnumFacing.SOUTH;
        } else if (facing == EnumFacing.SOUTH && south.func_185917_h() && !north.func_185917_h()) {
            facing = EnumFacing.NORTH;
        } else if (facing == EnumFacing.WEST && west.func_185917_h() && !east.func_185917_h()) {
            facing = EnumFacing.EAST;
        } else if (facing == EnumFacing.EAST && east.func_185917_h() && !west.func_185917_h()) {
            facing = EnumFacing.WEST;
        }
        world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing), 2);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockReader world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public IBlockState getDisguisedBlockState(IBlockReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityKeypad) {
            ItemStack module;
            TileEntityKeypad te = (TileEntityKeypad)world.func_175625_s(pos);
            ItemStack itemStack = module = te.hasModule(EnumCustomModules.DISGUISE) ? te.getModule(EnumCustomModules.DISGUISE) : ItemStack.field_190927_a;
            if (!module.func_190926_b() && !((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                return ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).func_176223_P();
            }
        }
        return null;
    }

    public static ItemStack getDisguisedStack(IBlockReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityKeypad) {
            ItemStack disguisedStack;
            ItemStack stack;
            TileEntityKeypad te = (TileEntityKeypad)world.func_175625_s(pos);
            ItemStack itemStack = stack = te.hasModule(EnumCustomModules.DISGUISE) ? te.getModule(EnumCustomModules.DISGUISE) : ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !((ItemModule)stack.func_77973_b()).getBlockAddons(stack.func_77978_p()).isEmpty() && Block.func_149634_a((Item)(disguisedStack = ((ItemModule)stack.func_77973_b()).getAddons(stack.func_77978_p()).get(0)).func_77973_b()) != SCContent.keypad) {
                return disguisedStack;
            }
        }
        return new ItemStack((IItemProvider)SCContent.keypad);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityKeypad();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return BlockKeypad.getDisguisedStack((IBlockReader)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return BlockKeypad.getDisguisedStack((IBlockReader)world, pos).func_77973_b() == this.func_199767_j();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return BlockKeypad.getDisguisedStack(world, pos);
    }

    @Override
    public Block getOriginalBlock() {
        return SCContent.frame;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, BlockPos pos) {
        world.func_175656_a(pos, (IBlockState)((IBlockState)SCContent.keypad.func_176223_P().func_206870_a((IProperty)FACING, world.func_180495_p(pos).func_177229_b((IProperty)BlockFrame.FACING))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        ((IOwnable)world.func_175625_s(pos)).setOwner(player.func_110124_au().toString(), player.func_200200_C_().func_150254_d());
        return true;
    }
}

