/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockKeypadChest
extends BlockChest
implements IPasswordConvertible {
    public BlockKeypadChest() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(-1.0f, 6000000.0f));
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker) && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityKeypadChest) {
                ((TileEntityKeypadChest)world.func_175625_s(pos)).openPasswordGUI(player);
            }
            return true;
        }
        return true;
    }

    public static void activate(World world, BlockPos pos, EntityPlayer player) {
        if (!BlockKeypadChest.isBlocked(world, pos)) {
            player.func_71007_a((IInventory)((BlockChest)BlockUtils.getBlock(world, pos)).func_196309_a(world.func_180495_p(pos), world, pos, false));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)entity));
        }
        if (world.func_175625_s(pos.func_177974_f()) != null && world.func_175625_s(pos.func_177974_f()) instanceof TileEntityKeypadChest) {
            ((TileEntityKeypadChest)world.func_175625_s(pos)).setPassword(((TileEntityKeypadChest)world.func_175625_s(pos.func_177974_f())).getPassword());
        } else if (world.func_175625_s(pos.func_177976_e()) != null && world.func_175625_s(pos.func_177976_e()) instanceof TileEntityKeypadChest) {
            ((TileEntityKeypadChest)world.func_175625_s(pos)).setPassword(((TileEntityKeypadChest)world.func_175625_s(pos.func_177976_e())).getPassword());
        } else if (world.func_175625_s(pos.func_177968_d()) != null && world.func_175625_s(pos.func_177968_d()) instanceof TileEntityKeypadChest) {
            ((TileEntityKeypadChest)world.func_175625_s(pos)).setPassword(((TileEntityKeypadChest)world.func_175625_s(pos.func_177968_d())).getPassword());
        } else if (world.func_175625_s(pos.func_177978_c()) != null && world.func_175625_s(pos.func_177978_c()) instanceof TileEntityKeypadChest) {
            ((TileEntityKeypadChest)world.func_175625_s(pos)).setPassword(((TileEntityKeypadChest)world.func_175625_s(pos.func_177978_c())).getPassword());
        }
    }

    public void onNeighborChange(IBlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        TileEntityKeypadChest tileentitychest = (TileEntityKeypadChest)world.func_175625_s(pos);
        if (tileentitychest != null) {
            tileentitychest.func_145836_u();
        }
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityKeypadChest();
    }

    public static boolean isBlocked(World world, BlockPos pos) {
        return BlockKeypadChest.isBelowSolidBlock(world, pos) || BlockKeypadChest.isOcelotSittingOnChest(world, pos);
    }

    private static boolean isBelowSolidBlock(World world, BlockPos pos) {
        return BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private static boolean isOcelotSittingOnChest(World world, BlockPos pos) {
        for (Entity entity : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Block getOriginalBlock() {
        return Blocks.field_150486_ae;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176459_a);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        NBTTagCompound tag = chest.func_189515_b(new NBTTagCompound());
        chest.func_174888_l();
        world.func_175656_a(pos, (IBlockState)SCContent.keypadChest.func_176223_P().func_206870_a((IProperty)field_176459_a, (Comparable)facing));
        ((IOwnable)world.func_175625_s(pos)).getOwner().set(player.func_110124_au().toString(), player.func_200200_C_().func_150254_d());
        ((TileEntityChest)world.func_175625_s(pos)).func_145839_a(tag);
        return true;
    }
}

