/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.TEInteractionObject;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadFurnace;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockKeypadFurnace
extends BlockOwnable
implements IPasswordConvertible {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final VoxelShape NORTH_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)2.0, (double)3.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)2.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)1.0, (double)11.0, (double)2.0, (double)2.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)), (VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)3.0, (double)15.0, (double)15.0, (double)4.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    private static final VoxelShape NORTH_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)3.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)14.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)14.0, (double)1.0, (double)11.0, (double)15.0, (double)2.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST));
    private static final VoxelShape EAST_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)2.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)2.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)1.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)), (VoxelShape)Block.func_208617_a((double)12.0, (double)2.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    private static final VoxelShape EAST_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)14.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)14.0, (double)14.0, (double)5.0, (double)15.0, (double)15.0, (double)11.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST));
    private static final VoxelShape SOUTH_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0, (double)14.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)2.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)14.0, (double)11.0, (double)2.0, (double)15.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)), (VoxelShape)Block.func_208617_a((double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)15.0, (double)13.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    private static final VoxelShape SOUTH_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)4.0, (double)14.0, (double)14.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)14.0, (double)14.0, (double)11.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST));
    private static final VoxelShape WEST_OPEN = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)2.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)5.0, (double)2.0, (double)2.0, (double)11.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)), (VoxelShape)Block.func_208617_a((double)3.0, (double)2.0, (double)1.0, (double)4.0, (double)15.0, (double)15.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST);
    private static final VoxelShape WEST_CLOSED = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0)), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)0.0, (double)14.0, (double)4.0, (double)2.0, (double)15.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)14.0, (double)5.0, (double)2.0, (double)15.0, (double)11.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST));

    public BlockKeypadFurnace(Material material) {
        super(SoundType.field_185852_e, Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                    return NORTH_OPEN;
                }
                return NORTH_CLOSED;
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                    return EAST_OPEN;
                }
                return EAST_CLOSED;
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                    return SOUTH_OPEN;
                }
                return SOUTH_CLOSED;
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                    return WEST_OPEN;
                }
                return WEST_CLOSED;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof BlockKeypadFurnace)) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !PlayerUtils.isHoldingItem(player, SCContent.codebreaker)) {
            ((TileEntityKeypadFurnace)world.func_175625_s(pos)).openPasswordGUI(player);
        }
        return true;
    }

    public static void activate(World world, BlockPos pos, EntityPlayer player) {
        if (!BlockUtils.getBlockPropertyAsBoolean(world, pos, OPEN)) {
            BlockUtils.setBlockProperty(world, pos, OPEN, true, false);
        }
        if (player instanceof EntityPlayerMP) {
            world.func_180498_a((EntityPlayer)null, 1006, pos, 0);
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new TEInteractionObject(GuiHandler.KEYPAD_FURNACE, world, pos), (BlockPos)pos);
        }
    }

    public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return (Boolean)state.func_177229_b((IProperty)OPEN) != false && te != null && te instanceof TileEntityKeypadFurnace && ((TileEntityKeypadFurnace)te).isBurning() ? 15 : 0;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d())).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{OPEN});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityKeypadFurnace();
    }

    @Override
    public Block getOriginalBlock() {
        return Blocks.field_150460_al;
    }

    @Override
    public boolean convert(EntityPlayer player, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TileEntityFurnace furnace = (TileEntityFurnace)world.func_175625_s(pos);
        NBTTagCompound tag = furnace.func_189515_b(new NBTTagCompound());
        furnace.func_174888_l();
        world.func_175656_a(pos, (IBlockState)((IBlockState)SCContent.keypadFurnace.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
        ((IOwnable)world.func_175625_s(pos)).getOwner().set(player.func_110124_au().toString(), player.func_200200_C_().func_150254_d());
        ((TileEntityKeypadFurnace)world.func_175625_s(pos)).func_145839_a(tag);
        return true;
    }
}

