/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.blocks.BlockLaserField;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityLaserBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockLaserBlock
extends BlockOwnable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public BlockLaserBlock(Material material) {
        super(SoundType.field_185852_e, Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f).func_200944_c());
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (!world.field_72995_K) {
            this.setLaser(world, pos);
        }
    }

    public void setLaser(World world, BlockPos pos) {
        block0: for (EnumFacing facing : EnumFacing.values()) {
            int boundType = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? 1 : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.CommonConfig.CONFIG.laserBlockRange.get(); ++i) {
                BlockPos offsetPos = pos.func_177967_a(facing, i);
                IBlockState state = world.func_180495_p(offsetPos);
                Block id = world.func_180495_p(offsetPos).func_177230_c();
                if (!state.isAir((IBlockReader)world, offsetPos) && id != SCContent.laserBlock) continue block0;
                if (id != SCContent.laserBlock) continue;
                CustomizableSCTE.link((CustomizableSCTE)world.func_175625_s(pos), (CustomizableSCTE)world.func_175625_s(offsetPos));
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.func_177967_a(facing, j);
                    if (!world.func_180495_p(offsetPos).isAir((IBlockReader)world, offsetPos)) continue;
                    world.func_175656_a(offsetPos, (IBlockState)SCContent.laserField.func_176223_P().func_206870_a((IProperty)BlockLaserField.BOUNDTYPE, (Comparable)Integer.valueOf(boundType)));
                }
            }
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (!world.func_201670_d()) {
            BlockLaserBlock.destroyAdjacentLasers(world, pos);
        }
    }

    public static void destroyAdjacentLasers(IWorld world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.values()) {
            int boundType = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? 1 : (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? 2 : 3);
            for (int i = 1; i <= (Integer)ConfigHandler.CommonConfig.CONFIG.laserBlockRange.get(); ++i) {
                BlockPos offsetPos = pos.func_177967_a(facing, i);
                if (world.func_180495_p(offsetPos).func_177230_c() != SCContent.laserBlock) continue;
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.func_177967_a(facing, j);
                    IBlockState state = world.func_180495_p(offsetPos);
                    if (state.func_177230_c() != SCContent.laserField || (Integer)state.func_177229_b((IProperty)BlockLaserField.BOUNDTYPE) != boundType) continue;
                    world.func_175655_b(offsetPos, false);
                }
            }
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty(world, pos, POWERED, false, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityLaserBlock().linkable();
    }
}

