/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLaserField
extends BlockContainer
implements IIntersectable {
    public static final IntegerProperty BOUNDTYPE = IntegerProperty.func_177719_a((String)"boundtype", (int)1, (int)3);
    private static final VoxelShape SHAPE_X = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_Y = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_Z = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);

    public BlockLaserField(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !EntityUtils.doesMobHavePotionEffect((EntityLivingBase)entity, (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation("minecraft:invisibility")))) {
            for (EnumFacing facing : EnumFacing.values()) {
                for (int i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.laserBlockRange.get(); ++i) {
                    BlockPos offsetPos = pos.func_177967_a(facing, i);
                    Block block = world.func_180495_p(offsetPos).func_177230_c();
                    if (block != SCContent.laserBlock || BlockUtils.getBlockPropertyAsBoolean(world, offsetPos, BlockLaserBlock.POWERED)) continue;
                    TileEntity te = world.func_175625_s(offsetPos);
                    if (te instanceof CustomizableSCTE && ((CustomizableSCTE)te).hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(world, offsetPos, EnumCustomModules.WHITELIST).contains(((EntityLivingBase)entity).func_200200_C_().func_150254_d().toLowerCase())) {
                        return;
                    }
                    BlockUtils.setBlockProperty(world, offsetPos, BlockLaserBlock.POWERED, true, true);
                    world.func_195593_d(offsetPos, SCContent.laserBlock);
                    world.func_205220_G_().func_205360_a(offsetPos, (Object)SCContent.laserBlock, 50);
                    if (!(te instanceof CustomizableSCTE) || !((CustomizableSCTE)te).hasModule(EnumCustomModules.HARMING)) continue;
                    ((EntityLivingBase)entity).func_70097_a((DamageSource)CustomDamageSources.laser, 10.0f);
                }
            }
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (!world.func_201670_d()) {
            for (EnumFacing facing : EnumFacing.values()) {
                for (int i = 0; i < (Integer)ConfigHandler.CommonConfig.CONFIG.laserBlockRange.get(); ++i) {
                    if (BlockUtils.getBlock((IBlockReader)world, pos.func_177967_a(facing, i)) != SCContent.laserBlock) continue;
                    for (int j = 1; j < i; ++j) {
                        world.func_175655_b(pos.func_177967_a(facing, j), false);
                    }
                }
            }
        }
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        if (source.func_180495_p(pos).func_177230_c() instanceof BlockLaserField) {
            int boundType = (Integer)source.func_180495_p(pos).func_177229_b((IProperty)BOUNDTYPE);
            if (boundType == 1) {
                return SHAPE_Y;
            }
            if (boundType == 2) {
                return SHAPE_Z;
            }
            if (boundType == 3) {
                return SHAPE_X;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)BOUNDTYPE, (Comparable)Integer.valueOf(1));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BOUNDTYPE});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntitySCTE().intersectsEntities();
    }
}

